/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dem.gpf.AddElevationOp;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateElevationOp {
    public static final String sep = File.separator;
    public static final String rootPathTestProducts = SystemUtils.getApplicationHomeDir() + sep + ".." + sep + ".." + sep + "testdata";
    public static final String inputSAR = rootPathTestProducts + sep + "input" + sep + "SAR" + sep;
    public static final File inputASAR_WSM = new File(inputSAR + "ASAR" + sep + "subset_1_of_ENVISAT-ASA_WSM_1PNPDE20080119_093446_000000852065_00165_30780_2977.dim");
    private static final OperatorSpi spi = new AddElevationOp.Spi();
    private static double[] expectedValues = new double[]{1526.274658203125, 1522.37060546875, 1533.1915283203125, 1552.01318359375, 1524.1387939453125, 1519.0521240234375, 1533.115966796875, 1555.3663330078125};

    @Test
    public void testProcessing() throws Exception {
        File inputFile = inputASAR_WSM;
        if (!inputFile.exists()) {
            TestUtils.skipTest((Object)this, (String)(inputFile + " not found"));
            return;
        }
        Product sourceProduct = TestUtils.readSourceProduct((File)inputFile);
        AddElevationOp op = (AddElevationOp)spi.createOperator();
        Assert.assertNotNull((Object)op);
        op.setSourceProduct(sourceProduct);
        Product targetProduct = op.getTargetProduct();
        TestUtils.verifyProduct((Product)targetProduct, (boolean)true, (boolean)true, (boolean)true);
        Band elevBand = targetProduct.getBand("elevation");
        Assert.assertNotNull((Object)elevBand);
        double[] demValues = new double[8];
        elevBand.readPixels(0, 0, 4, 2, demValues, ProgressMonitor.NULL);
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, demValues));
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)targetProduct);
    }
}

