/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.dem.dataio.ace.ACEReader;
import org.esa.snap.dem.dataio.ace.ACEReaderPlugIn;
import org.junit.Assert;
import org.junit.Test;

public class TestACEReaderPlugIn {
    private ACEReaderPlugIn _plugIn = new ACEReaderPlugIn();

    @Test
    public void testValidInputs() {
        this.checkValidInput("./ACE/00N015W.ACE");
        this.checkValidInput("./ACE/00N015W.ACE");
        this.checkValidInput("./ACE/00N015W.ACE");
    }

    private void checkValidInput(String s) {
        Assert.assertTrue((this._plugIn.getDecodeQualification((Object)s) == DecodeQualification.INTENDED ? 1 : 0) != 0);
        Assert.assertTrue((this._plugIn.getDecodeQualification((Object)new File(s)) == DecodeQualification.INTENDED ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidInputs() {
        this.checkInvalidInput("10n143w.ACE.zip");
        this.checkInvalidInput("./ACE/00N015W.ACE.zip");
        this.checkInvalidInput("./ACE/00N015W.ACE.zip");
        this.checkInvalidInput("./ACE/readme.txt");
        this.checkInvalidInput("./ACE/readme.txt.zip");
        this.checkInvalidInput("./ACE/readme");
        this.checkInvalidInput("./ACE/");
        this.checkInvalidInput("./");
        this.checkInvalidInput(".");
        this.checkInvalidInput("");
        this.checkInvalidInput("./ACE/.hgt");
        this.checkInvalidInput("./ACE/.hgt.zip");
        this.checkInvalidInput("./ACE/.hgt");
        this.checkInvalidInput("./ACE/.hgt.zip");
    }

    private void checkInvalidInput(String s) {
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification((Object)s));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification((Object)new File(s)));
    }

    @Test
    public void testThatOtherTypesCannotBeDecoded() throws MalformedURLException {
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification(null));
        URL url = new File("./ACE/readme.txt").toURI().toURL();
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification((Object)url));
        Object object = new Object();
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this._plugIn.getDecodeQualification(object));
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader reader = this._plugIn.createReaderInstance();
        Assert.assertTrue((boolean)(reader instanceof ACEReader));
    }

    @Test
    public void testGetInputTypes() {
        Class[] inputTypes = this._plugIn.getInputTypes();
        Assert.assertNotNull((Object)inputTypes);
        Assert.assertTrue((inputTypes.length == 2 ? 1 : 0) != 0);
        Assert.assertEquals(String.class, (Object)inputTypes[0]);
        Assert.assertEquals(File.class, (Object)inputTypes[1]);
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this._plugIn.getFormatNames();
        Assert.assertNotNull((Object)formatNames);
        Assert.assertTrue((formatNames.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ACE", (Object)formatNames[0]);
    }

    @Test
    public void testGetDefaultFileExtensions() {
        String[] defaultFileExtensions = this._plugIn.getDefaultFileExtensions();
        Assert.assertNotNull((Object)defaultFileExtensions);
        Assert.assertTrue((defaultFileExtensions.length == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)".ACE", (Object)defaultFileExtensions[0]);
    }
}

