/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.text.ParseException;
import org.esa.snap.dem.dataio.ace.ACEFileInfo;
import org.junit.Assert;
import org.junit.Test;

public class TestACEFileInfo {
    @Test
    public void testValidFileSize() {
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)2L));
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)8L));
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)18L));
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)32L));
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)50L));
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)2004002L));
        Assert.assertTrue((boolean)ACEFileInfo.isValidFileSize((long)93680672L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)-2L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)-1L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)0L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)1L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)3L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)4L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)5L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)6L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)7L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)9L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)87565L));
        Assert.assertFalse((boolean)ACEFileInfo.isValidFileSize((long)-76L));
    }

    @Test
    public void testExtractEastingNorthingWithValidStrings() throws ParseException {
        int[] values = ACEFileInfo.parseEastingNorthing((String)"00N015W.ACE");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((long)-15L, (long)values[0]);
        Assert.assertEquals((long)0L, (long)values[1]);
        values = ACEFileInfo.parseEastingNorthing((String)"75S135E.ACE");
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((long)135L, (long)values[0]);
        Assert.assertEquals((long)-75L, (long)values[1]);
    }

    @Test
    public void testExtractEastingNorthingWithInvalidStrings() {
        try {
            ACEFileInfo.parseEastingNorthing((String)"020n10w");
            Assert.fail((String)"ParseException expected because the string not ends with '\\..+' ");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Illegal string format.", (Object)expected.getMessage());
            Assert.assertEquals((long)7L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"005n104w");
            Assert.fail((String)"ParseException expected because the string not ends with '\\..+' ");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Illegal string format.", (Object)expected.getMessage());
            Assert.assertEquals((long)8L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"05S104E");
            Assert.fail((String)"ParseException expected because the string not ends with '\\..+' ");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Illegal string format.", (Object)expected.getMessage());
            Assert.assertEquals((long)7L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing(null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((expected.getMessage().indexOf("null") > -1 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            Assert.fail((String)"IllegalArgumentException expected");
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((expected.getMessage().indexOf("empty") > -1 ? 1 : 0) != 0);
        }
        catch (ParseException e) {
            Assert.fail((String)"IllegalArgumentException expected");
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"020n10aw");
            Assert.fail((String)"ParseException expected because illegal 'a' character");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Illegal direction character.", (Object)expected.getMessage());
            Assert.assertEquals((long)6L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"w0a0n10.ACE");
            Assert.fail((String)"ParseException expected because the string starts with no digit.");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Digit character expected.", (Object)expected.getMessage());
            Assert.assertEquals((long)0L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"100n10w.ACE");
            Assert.fail((String)"ParseException expected because the value for north direction is out of bounds.");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"The value '100' for north direction is out of the range 0 ... 90.", (Object)expected.getMessage());
            Assert.assertEquals((long)3L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"100s10w.ACE");
            Assert.fail((String)"ParseException expected because the value for south direction is out of bounds.");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"The value '-100' for south direction is out of the range -90 ... 0.", (Object)expected.getMessage());
            Assert.assertEquals((long)3L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"80n190e.ACE");
            Assert.fail((String)"ParseException expected because the value for east direction is out of bounds.");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"The value '190' for east direction is out of the range 0 ... 180.", (Object)expected.getMessage());
            Assert.assertEquals((long)6L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"80s190w.ACE");
            Assert.fail((String)"ParseException expected because the value for west direction is out of bounds.");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"The value '-190' for west direction is out of the range -180 ... 0.", (Object)expected.getMessage());
            Assert.assertEquals((long)6L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"80s80s.ACE");
            Assert.fail((String)"ParseException expected because value for easting is not available");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Easting value not available.", (Object)expected.getMessage());
            Assert.assertEquals((long)-1L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"80e80e.ACE");
            Assert.fail((String)"ParseException expected because value for northing is not available");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Northing value not available.", (Object)expected.getMessage());
            Assert.assertEquals((long)-1L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"80e80sACE");
            Assert.fail((String)"ParseException expected because northing easting values are not followed by a dot");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Illegal string format.", (Object)expected.getMessage());
            Assert.assertEquals((long)6L, (long)expected.getErrorOffset());
        }
        try {
            ACEFileInfo.parseEastingNorthing((String)"80e80s.");
            Assert.fail((String)"ParseException expected because the dot is not followed by at least one character");
        }
        catch (ParseException expected) {
            Assert.assertEquals((Object)"Illegal string format.", (Object)expected.getMessage());
            Assert.assertEquals((long)6L, (long)expected.getErrorOffset());
        }
    }
}

