/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.io.IOException;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.ace.ACEElevationModel;
import org.esa.snap.dem.dataio.ace.ACEElevationModelDescriptor;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestACEElevationModel {
    private static double[] expectedValues = new double[]{1100.0, 1149.0, 1080.0, 1037.0};

    @Ignore
    public void testElevationModel() throws Exception {
        ACEElevationModel dem = this.getElevationModel();
        int height = 2;
        int width = 2;
        double[] demValues = new double[width * height];
        int count = 0;
        GeoPos geoPos = new GeoPos(-18.0, 20.0);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                geoPos.setLocation(geoPos.getLat() + (double)x, geoPos.getLon() + (double)y);
                try {
                    demValues[count++] = dem.getElevation(geoPos);
                    continue;
                }
                catch (Exception e) {
                    Assert.assertFalse((String)("Get Elevation threw: " + e.getMessage()), (boolean)true);
                }
            }
        }
        Assert.assertArrayEquals((double[])expectedValues, (double[])demValues, (double)1.0E-6);
    }

    @Test
    public void testFilenameCreation() throws Exception {
        ACEElevationModel dem = this.getElevationModel();
        Assert.assertEquals((Object)"45S004W.ACE", (Object)dem.createTileFilename(-45, -4));
        Assert.assertEquals((Object)"45S004E.ACE", (Object)dem.createTileFilename(-45, 4));
        Assert.assertEquals((Object)"45N004W.ACE", (Object)dem.createTileFilename(45, -4));
        Assert.assertEquals((Object)"45N004E.ACE", (Object)dem.createTileFilename(45, 4));
        Assert.assertEquals((Object)"05S045W.ACE", (Object)dem.createTileFilename(-5, -45));
        Assert.assertEquals((Object)"05S045E.ACE", (Object)dem.createTileFilename(-5, 45));
        Assert.assertEquals((Object)"05N045W.ACE", (Object)dem.createTileFilename(5, -45));
        Assert.assertEquals((Object)"05N045E.ACE", (Object)dem.createTileFilename(5, 45));
        Assert.assertEquals((Object)"90S180W.ACE", (Object)dem.createTileFilename(-90, -180));
        Assert.assertEquals((Object)"90S180E.ACE", (Object)dem.createTileFilename(-90, 180));
        Assert.assertEquals((Object)"90N180W.ACE", (Object)dem.createTileFilename(90, -180));
        Assert.assertEquals((Object)"90N180E.ACE", (Object)dem.createTileFilename(90, 180));
    }

    private ACEElevationModel getElevationModel() throws IOException {
        return new ACEElevationModel(new ACEElevationModelDescriptor(), Resampling.BILINEAR_INTERPOLATION);
    }
}

