/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.util.Maths;

@OperatorMetadata(alias="Fill-DEM-Hole", category="Raster/DEM Tools", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Fill holes in given DEM product file.")
public final class FillDEMHoleOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    @Parameter(label="No Data Value", defaultValue="0.0")
    private double NoDataValue = 0.0;
    private int sourceImageWidth;
    private int sourceImageHeight;

    public void initialize() throws OperatorException {
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        try {
            this.getSourceImageDimension();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getSourceImageDimension() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (boolean)false);
        if (!ProductUtils.areRastersEqualInSize((RasterDataNode[])sourceBands)) {
            throw new OperatorException("Source bands must all be the same size");
        }
        for (Band srcBand : sourceBands) {
            if (srcBand instanceof VirtualBand) {
                VirtualBand sourceBand = (VirtualBand)srcBand;
                VirtualBand targetBand = new VirtualBand(sourceBand.getName(), sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), sourceBand.getExpression());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
                this.targetProduct.addBand((Band)targetBand);
                continue;
            }
            ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int x0 = targetTileRectangle.x;
            int y0 = targetTileRectangle.y;
            int w = targetTileRectangle.width;
            int h = targetTileRectangle.height;
            Rectangle sourceTileRectangle = this.getSourceRectangle(x0, y0, w, h);
            Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData srcData = sourceTile.getDataBuffer();
            ProductData trgData = targetTile.getDataBuffer();
            int maxY = y0 + h;
            int maxX = x0 + w;
            for (int y = y0; y < maxY; ++y) {
                for (int x = x0; x < maxX; ++x) {
                    double v = srcData.getElemDoubleAt(sourceTile.getDataBufferIndex(x, y));
                    if (v == this.NoDataValue) {
                        v = this.getPixelValueByInterpolation(x, y, srcData, sourceTile);
                    }
                    trgData.setElemDoubleAt(targetTile.getDataBufferIndex(x, y), v);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th) {
        int x0 = Math.max(0, tx0 - tw / 5);
        int y0 = Math.max(0, ty0 - th / 5);
        int xMax = Math.min(tx0 + tw - 1 + tw / 5, this.sourceImageWidth);
        int yMax = Math.min(ty0 + th - 1 + th / 5, this.sourceImageHeight);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    private double getPixelValueByInterpolation(int x, int y, ProductData srcData, Tile srcTile) {
        PixelPos pixelUp = new PixelPos((double)x, (double)y);
        PixelPos pixelDown = new PixelPos((double)x, (double)y);
        PixelPos pixelLeft = new PixelPos((double)x, (double)y);
        PixelPos pixelRight = new PixelPos((double)x, (double)y);
        double vUp = this.getNearestNonHolePixelPosition(x, y, srcData, srcTile, pixelUp, Direction.UP);
        double vDown = this.getNearestNonHolePixelPosition(x, y, srcData, srcTile, pixelDown, Direction.DOWN);
        double vLeft = this.getNearestNonHolePixelPosition(x, y, srcData, srcTile, pixelLeft, Direction.LEFT);
        double vRight = this.getNearestNonHolePixelPosition(x, y, srcData, srcTile, pixelRight, Direction.RIGHT);
        double v1 = this.NoDataValue;
        if (vUp != this.NoDataValue && vDown != this.NoDataValue) {
            double mu = ((double)y - pixelUp.y) / (pixelDown.y - pixelUp.y);
            v1 = Maths.interpolationLinear((double)vUp, (double)vDown, (double)mu);
        }
        double v2 = this.NoDataValue;
        if (vLeft != this.NoDataValue && vRight != this.NoDataValue) {
            double mu = ((double)x - pixelLeft.x) / (pixelRight.x - pixelLeft.x);
            v2 = Maths.interpolationLinear((double)vLeft, (double)vRight, (double)mu);
        }
        if (v1 != this.NoDataValue && v2 != this.NoDataValue) {
            return (v1 + v2) / 2.0;
        }
        if (v1 != this.NoDataValue) {
            return v1;
        }
        if (v2 != this.NoDataValue) {
            return v2;
        }
        return this.NoDataValue;
    }

    private double getNearestNonHolePixelPosition(int x, int y, ProductData srcData, Tile srcTile, PixelPos pixel, Direction dir) {
        Rectangle srcTileRectangle = srcTile.getRectangle();
        int x0 = srcTileRectangle.x;
        int y0 = srcTileRectangle.y;
        int w = srcTileRectangle.width;
        int h = srcTileRectangle.height;
        double v = 0.0;
        if (dir == Direction.UP) {
            for (int yy = y; yy >= y0; --yy) {
                v = srcData.getElemDoubleAt(srcTile.getDataBufferIndex(x, yy));
                if (v == this.NoDataValue) continue;
                pixel.y = yy;
                return v;
            }
        } else if (dir == Direction.DOWN) {
            for (int yy = y; yy < y0 + h; ++yy) {
                v = srcData.getElemDoubleAt(srcTile.getDataBufferIndex(x, yy));
                if (v == this.NoDataValue) continue;
                pixel.y = yy;
                return v;
            }
        } else if (dir == Direction.LEFT) {
            for (int xx = x; xx >= x0; --xx) {
                v = srcData.getElemDoubleAt(srcTile.getDataBufferIndex(xx, y));
                if (v == this.NoDataValue) continue;
                pixel.x = xx;
                return v;
            }
        } else if (dir == Direction.RIGHT) {
            for (int xx = x; xx < x0 + w; ++xx) {
                v = srcData.getElemDoubleAt(srcTile.getDataBufferIndex(xx, y));
                if (v == this.NoDataValue) continue;
                pixel.x = xx;
                return v;
            }
        } else {
            throw new OperatorException("Invalid direction");
        }
        return this.NoDataValue;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FillDEMHoleOp.class);
        }
    }

    private static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

