/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.dataio.FileElevationModel;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileGeoreferencing;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="AddElevation", category="Raster/DEM Tools", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Creates a DEM band")
public final class AddElevationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The digital elevation model.", defaultValue="SRTM 3Sec", label="Digital Elevation Model")
    private String demName = "SRTM 3Sec";
    @Parameter(description="The elevation band name.", defaultValue="elevation", label="Elevation Band Name")
    private String elevationBandName = "elevation";
    @Parameter(description="The external DEM file.", defaultValue=" ", label="External DEM")
    private String externalDEM = " ";
    @Parameter(defaultValue="BILINEAR_INTERPOLATION", label="Resampling Method")
    private String resamplingMethod = "BILINEAR_INTERPOLATION";
    private FileElevationModel fileElevationModel = null;
    private ElevationModel dem = null;
    private Band elevationBand = null;
    private double noDataValue = 0.0;
    private final Map<Band, Band> sourceRasterMap = new HashMap<Band, Band>(10);

    public void initialize() throws OperatorException {
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        try {
            if (this.externalDEM != null && !this.externalDEM.trim().isEmpty()) {
                this.fileElevationModel = new FileElevationModel(new File(this.externalDEM), this.resamplingMethod, null);
                this.noDataValue = this.fileElevationModel.getNoDataValue();
            } else {
                this.dem = DEMFactory.createElevationModel(this.demName, this.resamplingMethod);
                this.noDataValue = this.dem.getDescriptor().getNoDataValue();
            }
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (Band band : this.sourceProduct.getBands()) {
            if (band.getName().equalsIgnoreCase(this.elevationBandName)) {
                throw new OperatorException("Band " + this.elevationBandName + " already exists. Try another name.");
            }
            if (band instanceof VirtualBand) {
                VirtualBand sourceBand = (VirtualBand)band;
                VirtualBand targetBand = new VirtualBand(sourceBand.getName(), sourceBand.getDataType(), sourceBand.getRasterWidth(), sourceBand.getRasterHeight(), sourceBand.getExpression());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
                this.targetProduct.addBand((Band)targetBand);
                this.sourceRasterMap.put((Band)targetBand, band);
                continue;
            }
            if (this.targetProduct.containsBand(band.getName())) continue;
            Band targetBand = ProductUtils.copyBand((String)band.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(band.getSourceImage());
            this.sourceRasterMap.put(targetBand, band);
        }
        this.elevationBand = this.targetProduct.addBand(this.elevationBandName, 30);
        this.elevationBand.setNoDataValue(this.noDataValue);
        this.elevationBand.setNoDataValueUsed(true);
        this.elevationBand.setUnit("meters");
        this.elevationBand.setDescription(this.dem.getDescriptor().getName());
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            if (targetBand == this.elevationBand) {
                Rectangle targetRectangle = targetTile.getRectangle();
                int x0 = targetRectangle.x;
                int y0 = targetRectangle.y;
                int w = targetRectangle.width;
                int h = targetRectangle.height;
                ProductData trgData = targetTile.getDataBuffer();
                TileGeoreferencing tileGeoRef = new TileGeoreferencing(this.targetProduct, x0, y0, w, h);
                double demNoDataValue = this.dem.getDescriptor().getNoDataValue();
                double[][] localDEM = new double[h + 2][w + 2];
                DEMFactory.getLocalDEM(this.dem, demNoDataValue, this.resamplingMethod, tileGeoRef, x0, y0, w, h, this.sourceProduct, true, localDEM);
                TileIndex trgIndex = new TileIndex(targetTile);
                int maxX = x0 + w;
                int maxY = y0 + h;
                for (int y = y0; y < maxY; ++y) {
                    int yy = y - y0 + 1;
                    trgIndex.calculateStride(y);
                    for (int x = x0; x < maxX; ++x) {
                        trgData.setElemDoubleAt(trgIndex.getIndex(x), localDEM[yy][x - x0 + 1]);
                    }
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AddElevationOp.class);
        }
    }
}

