/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.aster;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dem.dataio.aster.AsterElevationModel;
import org.esa.snap.dem.dataio.aster.AsterElevationTile;

public final class AsterFile
extends ElevationFile {
    private final AsterElevationModel demModel;

    public AsterFile(AsterElevationModel model, File localFile, ProductReader reader) {
        super(localFile, reader);
        this.demModel = model;
    }

    protected Boolean getRemoteFile() throws IOException {
        this.remoteFileExists = false;
        return false;
    }

    protected ElevationTile createTile(Product product) throws IOException {
        AsterElevationTile tile = new AsterElevationTile(this.demModel, product);
        this.demModel.updateCache((ElevationTile)tile);
        return tile;
    }

    protected boolean findLocalFile() {
        if (this.localFile.exists() && this.localFile.isFile() && this.localFile.length() > 0L) {
            return true;
        }
        String name = FileUtils.getFilenameWithoutExtension((String)this.localFile.getName());
        String v2Name = name.replace("ASTGTM", "ASTGTM2");
        File v2File = new File(this.localFile.getParentFile(), v2Name + ".zip");
        if (v2File.exists()) {
            this.localFile = new File(this.localFile.getParentFile(), v2Name + "_dem.tif");
            this.localZipFile = v2File;
            return true;
        }
        File unzipFile = new File(this.localFile.getParentFile(), name + "_dem.tif");
        if (unzipFile.exists()) {
            this.localFile = unzipFile;
            return true;
        }
        File v2UnzipFile = new File(this.localFile.getParentFile(), v2Name + "_dem.tif");
        if (v2UnzipFile.exists()) {
            this.localFile = v2UnzipFile;
            return true;
        }
        return false;
    }

    protected InputStream getZipInputStream(File dataFile) throws IOException {
        if (!dataFile.exists()) {
            String v2Name = dataFile.getName().replace("ASTGTM", "ASTGTM2");
            dataFile = new File(dataFile.getParentFile(), v2Name);
        }
        return super.getZipInputStream(dataFile);
    }
}

