/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.esa.snap.engine_utilities.util.Maths;

public final class EarthGravitationalModel96 {
    private static final String NAME = "ww15mgh_b.grd";
    private static final String ZIPNAME = "ww15mgh_b.zip";
    private static final int NUM_LATS = 721;
    private static final int NUM_LONS = 1441;
    private static final int NUM_CHAR_PER_NORMAL_LINE = 74;
    private static final int NUM_CHAR_PER_SHORT_LINE = 11;
    private static final int NUM_CHAR_PER_EMPTY_LINE = 1;
    private static final int BLOCK_HEIGHT = 20;
    private static final int NUM_OF_BLOCKS_PER_LAT = 9;
    private static final int MAX_LATS = 720;
    private static final int MAX_LONS = 1440;
    private final float[][] egm;
    private static EarthGravitationalModel96 theInstance = null;

    public static EarthGravitationalModel96 instance() throws IOException {
        if (theInstance == null) {
            theInstance = new EarthGravitationalModel96();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EarthGravitationalModel96() throws IOException {
        Throwable throwable;
        InputStream inputStream;
        block34: {
            this.egm = new float[721][1441];
            URL egmDataPath = this.getClass().getClassLoader().getResource("org/esa/snap/auxdata/egm96/ww15mgh_b.grd");
            if (egmDataPath == null) {
                throw new IOException("Unable to load EGM96 ww15mgh_b.grd");
            }
            inputStream = null;
            try {
                if (NAME.endsWith(".zip")) {
                    throwable = null;
                    try (ZipFile zipFile = new ZipFile(egmDataPath.getFile());){
                        ZipEntry entry = zipFile.getEntry(NAME);
                        inputStream = zipFile.getInputStream(entry);
                        break block34;
                    }
                    catch (Throwable entry) {
                        throwable = entry;
                        throw entry;
                    }
                }
                inputStream = egmDataPath.openStream();
            }
            catch (Exception e) {
                throw new IOException("EarthGravitationalModel96 file not found: " + egmDataPath, e);
            }
        }
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line = "";
                int rowIdx = 0;
                int colIdx = 0;
                boolean numLatLinesToSkip = false;
                int numCharInHeader = 75;
                int numCharInEachLatLine = 13341;
                int totalCharToSkip = 75;
                reader.skip(75L);
                int numLinesInEachLatLine = 191;
                int numLinesToRead = 137711;
                int linesRead = 0;
                for (int i = 0; i < 137710; ++i) {
                    line = reader.readLine();
                    ++linesRead;
                    if (!line.equals("")) {
                        StringTokenizer st = new StringTokenizer(line);
                        int numCols = st.countTokens();
                        for (int j = 0; j < numCols; ++j) {
                            this.egm[rowIdx][colIdx] = Float.parseFloat(st.nextToken());
                            ++colIdx;
                        }
                    }
                    if (linesRead % 191 != 0) continue;
                    ++rowIdx;
                    colIdx = 0;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            inputStream.close();
        }
    }

    public float getEGM(double lat, double lon) {
        double[][] v = new double[4][4];
        return this.getEGM(lat, lon, v);
    }

    public float getEGM(double lat, double lon, double[][] v) {
        double r = (90.0 - lat) / 0.25;
        double c = (lon < 0.0 ? lon + 360.0 : lon) / 0.25;
        int r0 = Math.max((int)r - 1, 0);
        int c0 = Math.max((int)c - 1, 0);
        int ci1 = c0 + 1;
        int ci2 = c0 + 2;
        int ci3 = c0 + 3;
        if (ci3 > 1440) {
            c0 = Math.min(c0, 1440);
            ci1 = Math.min(ci1, 1440);
            ci2 = Math.min(ci2, 1440);
            ci3 = Math.min(ci3, 1440);
        }
        for (int i = 0; i < 4; ++i) {
            int ri = r0 + i > 720 ? 720 : r0 + i;
            v[i][0] = this.egm[ri][c0];
            v[i][1] = this.egm[ri][ci1];
            v[i][2] = this.egm[ri][ci2];
            v[i][3] = this.egm[ri][ci3];
        }
        return (float)Maths.interpolationBiCubic((double[][])v, (double)(c - (double)(c0 + 1)), (double)(r - (double)(r0 + 1)));
    }
}

