/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.csv.dataio;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.csv.dataio.CsvFile;
import org.esa.snap.csv.dataio.CsvSource;
import org.esa.snap.csv.dataio.CsvSourceParser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.PropertyDescriptor;

public class CsvFileTest {
    @Test
    public void testParseProperties() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_example.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        parser.parseMetadata();
        CsvSource source = parser.parseMetadata();
        Map properties = source.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertEquals((long)5L, (long)properties.size());
        Assert.assertEquals((Object)"POLYGON(0.0, 1.0, 1.1)", properties.get("geometry1"));
        Assert.assertEquals((Object)"POLYGON(2.0, 1.0, 1.1)", properties.get("geometry2"));
        Assert.assertEquals((Object)",", properties.get("separator"));
        Assert.assertEquals((Object)"3", properties.get("sceneRasterWidth"));
    }

    @Test(expected=IOException.class)
    public void testParseProperties_Fail() throws Exception {
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)"invalid_path");
        parser.parseMetadata();
    }

    @Test
    public void testParseRecords() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_example.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        CsvSource csvSource = parser.parseMetadata();
        parser.parseRecords(0, 3);
        SimpleFeature[] features = csvSource.getSimpleFeatures();
        Assert.assertEquals((long)4L, (long)csvSource.getRecordCount());
        Assert.assertEquals((long)3L, (long)features.length);
        SimpleFeature feature = features[0];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"26", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(3).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(6).getClass());
        feature = features[1];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"28", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(3).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(null, (Object)feature.getAttribute(6));
        feature = features[2];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"371", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(null, (Object)feature.getAttribute(3));
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(6).getClass());
        Assert.assertEquals((Object)"AMRU1", (Object)features[0].getAttribute(0));
        Assert.assertEquals((Object)"AMRU1", (Object)features[1].getAttribute(0));
        Assert.assertEquals((Object)"AMRU2", (Object)features[2].getAttribute(0));
        Assert.assertEquals((Object)new GeoPos(30.0, 50.0), (Object)new GeoPos((double)((Float)features[0].getAttribute(1)).floatValue(), (double)((Float)features[0].getAttribute(2)).floatValue()));
        Assert.assertEquals((Object)new GeoPos(30.0, 50.0), (Object)new GeoPos((double)((Float)features[1].getAttribute(1)).floatValue(), (double)((Float)features[1].getAttribute(2)).floatValue()));
        Assert.assertEquals((Object)new GeoPos(40.0, 120.0), (Object)new GeoPos((double)((Float)features[2].getAttribute(1)).floatValue(), (double)((Float)features[2].getAttribute(2)).floatValue()));
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01 12:45:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[0].getAttribute(3)).getAsDate().getTime());
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01 12:48:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[1].getAttribute(3)).getAsDate().getTime());
        Assert.assertEquals(null, (Object)features[2].getAttribute(3));
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), (Object)features[0].getAttribute(4));
        Assert.assertEquals((Object)Float.valueOf(18.3f), (Object)features[1].getAttribute(4));
        Assert.assertEquals((Object)Float.valueOf(10.6f), (Object)features[2].getAttribute(5));
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-06-01 10:45:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[0].getAttribute(6)).getAsDate().getTime());
    }

    @Test
    public void testParseRecords_NoFeatureId() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_no_feature_id.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        CsvSource csvSource = parser.parseMetadata();
        parser.parseRecords(0, 3);
        SimpleFeature[] features = csvSource.getSimpleFeatures();
        Assert.assertEquals((long)3L, (long)csvSource.getRecordCount());
        Assert.assertEquals((long)3L, (long)features.length);
        SimpleFeature feature = features[0];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"0", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(3).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(6).getClass());
        feature = features[1];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"1", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(3).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(null, (Object)feature.getAttribute(6));
        feature = features[2];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"2", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(null, (Object)feature.getAttribute(3));
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(6).getClass());
        Assert.assertEquals((Object)"AMRU1", (Object)features[0].getAttribute(0));
        Assert.assertEquals((Object)"AMRU1", (Object)features[1].getAttribute(0));
        Assert.assertEquals((Object)"AMRU2", (Object)features[2].getAttribute(0));
        Assert.assertEquals((Object)new GeoPos(30.0, 50.0), (Object)new GeoPos((double)((Float)features[0].getAttribute(1)).floatValue(), (double)((Float)features[0].getAttribute(2)).floatValue()));
        Assert.assertEquals((Object)new GeoPos(30.0, 50.0), (Object)new GeoPos((double)((Float)features[1].getAttribute(1)).floatValue(), (double)((Float)features[1].getAttribute(2)).floatValue()));
        Assert.assertEquals((Object)new GeoPos(40.0, 120.0), (Object)new GeoPos((double)((Float)features[2].getAttribute(1)).floatValue(), (double)((Float)features[2].getAttribute(2)).floatValue()));
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01 12:45:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[0].getAttribute(3)).getAsDate().getTime());
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01 12:48:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[1].getAttribute(3)).getAsDate().getTime());
        Assert.assertEquals(null, (Object)features[2].getAttribute(3));
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), (Object)features[0].getAttribute(4));
        Assert.assertEquals((Object)Float.valueOf(18.3f), (Object)features[1].getAttribute(4));
        Assert.assertEquals((Object)Float.valueOf(10.6f), (Object)features[2].getAttribute(5));
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2011-06-01 10:45:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[0].getAttribute(6)).getAsDate().getTime());
    }

    @Test
    public void testParseRecords_NotAllRecords() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_example.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        CsvSource csvSource = parser.parseMetadata();
        parser.parseRecords(1, 2);
        SimpleFeature[] features = csvSource.getSimpleFeatures();
        Assert.assertEquals((long)4L, (long)csvSource.getRecordCount());
        Assert.assertEquals((long)2L, (long)features.length);
        SimpleFeature feature = features[0];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"28", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(3).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(null, (Object)feature.getAttribute(6));
        feature = features[1];
        Assert.assertEquals((long)7L, (long)feature.getAttributeCount());
        Assert.assertEquals((Object)"371", (Object)feature.getID());
        Assert.assertEquals(String.class, feature.getAttribute(0).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(1).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(2).getClass());
        Assert.assertEquals(null, (Object)feature.getAttribute(3));
        Assert.assertEquals(Float.class, feature.getAttribute(4).getClass());
        Assert.assertEquals(Float.class, feature.getAttribute(5).getClass());
        Assert.assertEquals(ProductData.UTC.class, feature.getAttribute(6).getClass());
        Assert.assertEquals((Object)"AMRU1", (Object)features[0].getAttribute(0));
        Assert.assertEquals((Object)"AMRU2", (Object)features[1].getAttribute(0));
        Assert.assertEquals((Object)new GeoPos(30.0, 50.0), (Object)new GeoPos((double)((Float)features[0].getAttribute(1)).floatValue(), (double)((Float)features[0].getAttribute(2)).floatValue()));
        Assert.assertEquals((Object)new GeoPos(40.0, 120.0), (Object)new GeoPos((double)((Float)features[1].getAttribute(1)).floatValue(), (double)((Float)features[1].getAttribute(2)).floatValue()));
        Assert.assertEquals((long)ProductData.UTC.parse((String)"2010-06-01 12:48:00", (String)"yyyy-MM-dd HH:mm:ss").getAsDate().getTime(), (long)((ProductData.UTC)features[0].getAttribute(3)).getAsDate().getTime());
        Assert.assertEquals(null, (Object)features[1].getAttribute(3));
        Assert.assertEquals((Object)Float.valueOf(18.3f), (Object)features[0].getAttribute(4));
        Assert.assertEquals((Object)Float.valueOf(10.6f), (Object)features[1].getAttribute(5));
    }

    @Test
    public void testParseRecords_LessRecordsThanExpected() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_example.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        CsvSource csvSource = parser.parseMetadata();
        parser.parseRecords(0, 10);
        SimpleFeature[] features = csvSource.getSimpleFeatures();
        Assert.assertEquals((long)4L, (long)csvSource.getRecordCount());
        Assert.assertEquals((long)4L, (long)features.length);
    }

    @Test
    public void testParseHeader() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_example.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        parser.parseMetadata();
        CsvSource csvSource = parser.parseMetadata();
        SimpleFeatureType featureType = csvSource.getFeatureType();
        Assert.assertNotNull((Object)featureType);
        PropertyDescriptor[] propertyDescriptors = this.toPropertyDescriptorArray(featureType.getDescriptors());
        Assert.assertEquals((long)7L, (long)propertyDescriptors.length);
        Assert.assertEquals((Object)"station", (Object)propertyDescriptors[0].getName().toString());
        Assert.assertEquals((Object)"lat", (Object)propertyDescriptors[1].getName().toString());
        Assert.assertEquals((Object)"lon", (Object)propertyDescriptors[2].getName().toString());
        Assert.assertEquals((Object)"date_time", (Object)propertyDescriptors[3].getName().toString());
        Assert.assertEquals((Object)"radiance_1", (Object)propertyDescriptors[4].getName().toString());
        Assert.assertEquals((Object)"radiance_2", (Object)propertyDescriptors[5].getName().toString());
        Assert.assertEquals((Object)"testTime", (Object)propertyDescriptors[6].getName().toString());
        Assert.assertEquals((long)7L, (long)propertyDescriptors.length);
        Assert.assertTrue((boolean)propertyDescriptors[0].getType().getBinding().getSimpleName().matches(".*String"));
        Assert.assertTrue((boolean)propertyDescriptors[1].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[2].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[3].getType().getBinding().getSimpleName().matches(".*UTC"));
        Assert.assertTrue((boolean)propertyDescriptors[4].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[5].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[6].getType().getBinding().getSimpleName().matches(".*UTC"));
    }

    @Test
    public void testParseHeader_NoFeatureId() throws Exception {
        String simpleFormatExample = this.getClass().getResource("reader/simple_format_no_feature_id.txt").getFile();
        CsvSourceParser parser = CsvFile.createCsvSourceParser((String)simpleFormatExample);
        parser.parseMetadata();
        CsvSource csvSource = parser.parseMetadata();
        SimpleFeatureType featureType = csvSource.getFeatureType();
        Assert.assertNotNull((Object)featureType);
        PropertyDescriptor[] propertyDescriptors = this.toPropertyDescriptorArray(featureType.getDescriptors());
        Assert.assertEquals((long)7L, (long)propertyDescriptors.length);
        Assert.assertEquals((Object)"station", (Object)propertyDescriptors[0].getName().toString());
        Assert.assertEquals((Object)"lat", (Object)propertyDescriptors[1].getName().toString());
        Assert.assertEquals((Object)"lon", (Object)propertyDescriptors[2].getName().toString());
        Assert.assertEquals((Object)"date_time", (Object)propertyDescriptors[3].getName().toString());
        Assert.assertEquals((Object)"radiance_1", (Object)propertyDescriptors[4].getName().toString());
        Assert.assertEquals((Object)"radiance_2", (Object)propertyDescriptors[5].getName().toString());
        Assert.assertEquals((Object)"testTime", (Object)propertyDescriptors[6].getName().toString());
        Assert.assertEquals((long)7L, (long)propertyDescriptors.length);
        Assert.assertTrue((boolean)propertyDescriptors[0].getType().getBinding().getSimpleName().matches(".*String"));
        Assert.assertTrue((boolean)propertyDescriptors[1].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[2].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[3].getType().getBinding().getSimpleName().matches(".*UTC"));
        Assert.assertTrue((boolean)propertyDescriptors[4].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[5].getType().getBinding().getSimpleName().matches(".*Float"));
        Assert.assertTrue((boolean)propertyDescriptors[6].getType().getBinding().getSimpleName().matches(".*UTC"));
    }

    private PropertyDescriptor[] toPropertyDescriptorArray(Collection<PropertyDescriptor> descriptors) {
        Object[] objects = descriptors.toArray(new Object[descriptors.size()]);
        PropertyDescriptor[] propertyDescriptors = new PropertyDescriptor[objects.length];
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            propertyDescriptors[i] = (PropertyDescriptor)objects[i];
        }
        return propertyDescriptors;
    }
}

