/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.collocation;

import java.awt.Color;
import org.esa.beam.collocation.CollocateOp;
import org.esa.beam.collocation.ResamplingType;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.MapGeoCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.framework.dataop.maptransf.MapInfo;
import org.esa.beam.framework.dataop.maptransf.MapProjectionRegistry;
import org.junit.Assert;
import org.junit.Test;

public class CollocateOpTest {
    static float[] wl = new float[]{412.63956f, 442.51602f, 489.8733f, 509.83f, 559.75757f, 619.7248f, 664.7287f, 680.9848f, 708.49896f, 753.53125f, 761.7092f, 778.552f, 864.88f, 884.8976f, 899.91003f};

    @Test
    public void testIt() {
        Product masterProduct = CollocateOpTest.createTestProduct1();
        Product slaveProduct = CollocateOpTest.createTestProduct2();
        CollocateOp op = new CollocateOp();
        op.setParameterDefaultValues();
        Assert.assertEquals((Object)"COLLOCATED", (Object)op.getTargetProductType());
        Assert.assertEquals((Object)true, (Object)op.getRenameMasterComponents());
        Assert.assertEquals((Object)true, (Object)op.getRenameSlaveComponents());
        Assert.assertEquals((Object)"${ORIGINAL_NAME}_M", (Object)op.getMasterComponentPattern());
        Assert.assertEquals((Object)"${ORIGINAL_NAME}_S", (Object)op.getSlaveComponentPattern());
        Assert.assertEquals((Object)ResamplingType.NEAREST_NEIGHBOUR, (Object)op.getResamplingType());
        op.setMasterProduct(masterProduct);
        op.setSlaveProduct(slaveProduct);
        Product targetProduct = op.getTargetProduct();
        int numMasterBands = masterProduct.getNumBands();
        int numSlaveBands = slaveProduct.getNumBands();
        int numMasterTPGs = masterProduct.getNumTiePointGrids();
        int numSlaveTPGs = slaveProduct.getNumTiePointGrids();
        Assert.assertEquals((long)(numMasterBands + numSlaveBands + numSlaveTPGs), (long)targetProduct.getNumBands());
        Assert.assertEquals((long)numMasterTPGs, (long)targetProduct.getNumTiePointGrids());
        Assert.assertEquals((Object)"radiance_1_M", (Object)targetProduct.getBandAt(0).getName());
        Assert.assertEquals((Object)"radiance_2_M", (Object)targetProduct.getBandAt(1).getName());
        Assert.assertEquals((Object)"l1_flags_M", (Object)targetProduct.getBandAt(15).getName());
        Assert.assertEquals((Object)"reflec_1_S", (Object)targetProduct.getBandAt(16).getName());
        Assert.assertEquals((Object)"reflec_2_S", (Object)targetProduct.getBandAt(17).getName());
        Assert.assertEquals((Object)"l2_flags_S", (Object)targetProduct.getBandAt(31).getName());
        Assert.assertEquals((Object)"latitude_S", (Object)targetProduct.getBandAt(32).getName());
        Assert.assertEquals((Object)"longitude_S", (Object)targetProduct.getBandAt(33).getName());
        Assert.assertEquals((Object)"dem_altitude_S", (Object)targetProduct.getBandAt(34).getName());
        Assert.assertEquals((Object)"!l1_flags_M.INVALID && radiance_1_M > 10", (Object)targetProduct.getBandAt(0).getValidMaskExpression());
        Assert.assertEquals((Object)"!l1_flags_M.INVALID && radiance_1_M > 10", (Object)targetProduct.getBandAt(1).getValidMaskExpression());
        Assert.assertEquals((Object)"!l2_flags_S.INVALID && reflec_1_S > 0.1", (Object)targetProduct.getBandAt(16).getValidMaskExpression());
        Assert.assertEquals((Object)"!l2_flags_S.INVALID && reflec_1_S > 0.1", (Object)targetProduct.getBandAt(17).getValidMaskExpression());
        Assert.assertEquals((long)1L, (long)targetProduct.getMaskGroup().getNodeCount());
        Mask mask = (Mask)targetProduct.getMaskGroup().get(0);
        Assert.assertNotNull((Object)mask);
        Assert.assertEquals((Object)"bitmask_M", (Object)mask.getName());
        Assert.assertEquals((Object)"radiance_1_M > 10", (Object)Mask.BandMathsType.getExpression((Mask)mask));
        Assert.assertEquals((Object)Color.RED, (Object)mask.getImageColor());
        Assert.assertEquals((double)0.5, (double)mask.getImageTransparency(), (double)1.0E-5);
    }

    public static Product createTestProduct1() {
        Product product = new Product("MER_RR_1P", "MER_RR_1P", 16, 16);
        for (int i = 0; i < wl.length; ++i) {
            VirtualBand band = new VirtualBand("radiance_" + (i + 1), 30, 16, 16, "X+Y");
            band.setValidPixelExpression("!l1_flags.INVALID && radiance_1 > 10");
            band.setSpectralWavelength(wl[i]);
            band.setSpectralBandIndex(i);
            product.addBand((Band)band);
        }
        product.addBand("l1_flags", 22);
        product.addTiePointGrid(CollocateOpTest.createTPG("latitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("longitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("dem_altitude"));
        MapInfo mapInfo1 = new MapInfo(MapProjectionRegistry.getProjection((String)"Geographic Lat/Lon"), 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, 0.1f, Datum.WGS_84);
        mapInfo1.setSceneWidth(16);
        mapInfo1.setSceneHeight(16);
        product.setGeoCoding((GeoCoding)new MapGeoCoding(mapInfo1));
        product.addMask("bitmask", "radiance_1 > 10", null, Color.RED, 0.5);
        return product;
    }

    public static Product createTestProduct2() {
        Product product = new Product("MER_RR_2P", "MER_RR_2P", 16, 16);
        for (int i = 0; i < wl.length; ++i) {
            VirtualBand band = new VirtualBand("reflec_" + (i + 1), 30, 16, 16, "X*Y");
            band.setValidPixelExpression("!l2_flags.INVALID && reflec_1 > 0.1");
            band.setSpectralWavelength(wl[i]);
            band.setSpectralBandIndex(i);
            product.addBand((Band)band);
        }
        product.addBand("l2_flags", 22);
        product.addTiePointGrid(CollocateOpTest.createTPG("latitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("longitude"));
        product.addTiePointGrid(CollocateOpTest.createTPG("dem_altitude"));
        MapInfo mapInfo2 = new MapInfo(MapProjectionRegistry.getProjection((String)"Geographic Lat/Lon"), 0.0f, 0.0f, 0.2f, 0.2f, 0.1f, 0.1f, Datum.WGS_84);
        mapInfo2.setSceneWidth(16);
        mapInfo2.setSceneHeight(16);
        product.setGeoCoding((GeoCoding)new MapGeoCoding(mapInfo2));
        return product;
    }

    private static TiePointGrid createTPG(String name) {
        return new TiePointGrid(name, 5, 5, 0.5f, 0.5f, 4.0f, 4.0f, new float[25]);
    }
}

