/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.cluster;

import junit.framework.TestCase;
import org.esa.snap.cluster.MultinormalDistribution;

public class MultinormalDistributionTest
extends TestCase {
    public void test1D() {
        MultinormalDistribution dist = new MultinormalDistribution(new double[]{0.0}, (double[][])new double[][]{{1.0}});
        double maximum = 1.0 / Math.sqrt(Math.PI * 2);
        MultinormalDistributionTest.assertEquals((double)maximum, (double)dist.probabilityDensity(new double[]{0.0}), (double)1.0E-14);
        double expectedValue = maximum * Math.exp(-0.5);
        MultinormalDistributionTest.assertEquals((double)expectedValue, (double)dist.probabilityDensity(new double[]{1.0}), (double)1.0E-14);
    }

    public void test2D() {
        MultinormalDistribution dist = new MultinormalDistribution(new double[]{0.0, 0.0}, (double[][])new double[][]{{1.0, 0.0}, {0.0, 2.0}});
        double maximum = 0.15915494309189535 / Math.sqrt(2.0);
        MultinormalDistributionTest.assertEquals((double)maximum, (double)dist.probabilityDensity(new double[]{0.0, 0.0}), (double)1.0E-14);
        double expectedValue = maximum * Math.exp(-0.75);
        MultinormalDistributionTest.assertEquals((double)expectedValue, (double)dist.probabilityDensity(new double[]{1.0, 1.0}), (double)1.0E-14);
    }
}

