/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.ModuleState;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.swing.update.ModuleItem;
import java.util.HashMap;

class ModuleSyncRunner {
    ModuleSyncRunner() {
    }

    public static ModuleItem[] sync(ModuleItem[] installedModuleItems, Module[] repositoryModules) {
        HashMap<String, ModuleItem> imap = new HashMap<String, ModuleItem>(installedModuleItems.length);
        for (ModuleItem installedModuleItem : installedModuleItems) {
            imap.put(installedModuleItem.getModule().getSymbolicName(), installedModuleItem);
        }
        HashMap<String, ModuleItem> syncList = new HashMap<String, ModuleItem>(installedModuleItems.length);
        for (Module repositoryModule : repositoryModules) {
            ModuleItem installedItem = (ModuleItem)imap.get(repositoryModule.getSymbolicName());
            if (installedItem != null) {
                Version installedVersion = installedItem.getModule().getVersion();
                Version availableVersion = repositoryModule.getVersion();
                if (!installedItem.getModule().getState().isOneOf(ModuleState.ACTIVE, new ModuleState[]{ModuleState.INSTALLED, ModuleState.RESOLVED}) || availableVersion.compareTo((Object)installedVersion) <= 0) continue;
                if (installedItem.getRepositoryModule() != null) {
                    Version updateVersion = installedItem.getRepositoryModule().getVersion();
                    if (availableVersion.compareTo((Object)updateVersion) <= 0) continue;
                    installedItem.setRepositoryModule(repositoryModule);
                    continue;
                }
                installedItem.setRepositoryModule(repositoryModule);
                continue;
            }
            ModuleItem moduleItem = (ModuleItem)syncList.get(repositoryModule.getSymbolicName());
            if (moduleItem != null) {
                if (moduleItem.getModule().getVersion().compareTo((Object)repositoryModule.getVersion()) >= 0) continue;
                syncList.put(repositoryModule.getSymbolicName(), new ModuleItem(repositoryModule));
                continue;
            }
            syncList.put(repositoryModule.getSymbolicName(), new ModuleItem(repositoryModule));
        }
        return syncList.values().toArray(new ModuleItem[syncList.size()]);
    }
}

