/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.runtime.Dependency;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.Version;
import com.bc.ceres.core.runtime.internal.ModuleImpl;
import com.bc.ceres.swing.update.MissingDependencyInfo;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class ConsistencyChecker {
    private HashMap<String, MissingDependencyInfo> missingDependencies;
    private ModuleManager moduleManager;

    public ConsistencyChecker(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    public boolean check() {
        this.reset();
        Map<String, Module> moduleMap = this.getCurrentModuleMap();
        Collection<Module> modules = moduleMap.values();
        for (Module module : modules) {
            Dependency[] declaredDependencies;
            for (Dependency dependency : declaredDependencies = module.getDeclaredDependencies()) {
                Module dependencyModule;
                if (!ConsistencyChecker.isMandatoryModuleDependency(dependency)) continue;
                String requiredVersionStr = dependency.getVersion();
                Version requiredVersion = null;
                if (requiredVersionStr != null) {
                    requiredVersion = Version.parseVersion((String)requiredVersionStr);
                }
                if ((dependencyModule = ConsistencyChecker.findModule(moduleMap, dependency.getModuleSymbolicName(), requiredVersion)) != null) continue;
                this.addMissingDependency(dependency, module);
            }
        }
        return this.missingDependencies == null;
    }

    private Map<String, Module> getCurrentModuleMap() {
        ModuleImpl module;
        HashMap<String, Module> modules = new HashMap<String, Module>(37);
        for (ModuleItem installedModuleItem : this.moduleManager.getInstalledModuleItems()) {
            Module repositoryModule;
            if (installedModuleItem.getAction().equals((Object)ModuleItem.Action.NONE) || installedModuleItem.getAction().equals((Object)ModuleItem.Action.UPDATE)) {
                module = installedModuleItem.getModule();
                modules.put(module.getSymbolicName(), (Module)module);
            }
            if (!installedModuleItem.getAction().equals((Object)ModuleItem.Action.UPDATE) || (repositoryModule = installedModuleItem.getRepositoryModule()) == null) continue;
            modules.put(repositoryModule.getSymbolicName(), repositoryModule);
        }
        for (ModuleItem availableModuleItem : this.moduleManager.getAvailableModuleItems()) {
            if (!availableModuleItem.getAction().equals((Object)ModuleItem.Action.INSTALL)) continue;
            module = availableModuleItem.getModule();
            modules.put(module.getSymbolicName(), (Module)module);
        }
        return modules;
    }

    private void reset() {
        if (this.missingDependencies != null) {
            this.missingDependencies.clear();
            this.missingDependencies = null;
        }
    }

    public void addMissingDependency(Dependency dependency, Module dependentModule) {
        String dependencyKey;
        if (this.missingDependencies == null) {
            this.missingDependencies = new HashMap(10);
        }
        if (this.missingDependencies.get(dependencyKey = dependency.getModuleSymbolicName() + dependency.getVersion()) == null) {
            MissingDependencyInfo dependencyInfo = new MissingDependencyInfo(dependency);
            this.missingDependencies.put(dependencyKey, dependencyInfo);
        }
        this.missingDependencies.get(dependencyKey).addDependentModule(dependentModule);
    }

    public MissingDependencyInfo[] getMissingDependencies() {
        if (this.missingDependencies == null) {
            return new MissingDependencyInfo[0];
        }
        return this.missingDependencies.values().toArray(new MissingDependencyInfo[this.missingDependencies.size()]);
    }

    private static boolean isMandatoryModuleDependency(Dependency dependency) {
        return dependency.getModuleSymbolicName() != null && !dependency.isOptional();
    }

    private static Module findModule(Map<String, Module> modules, String symbolicName, Version requiredVersion) {
        Module module = modules.get(symbolicName);
        if (requiredVersion == null) {
            return module;
        }
        if (module != null && module.getVersion().compareTo((Object)requiredVersion) >= 0) {
            return module;
        }
        return null;
    }
}

