/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.undo;

import com.bc.ceres.swing.undo.Restorable;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class RestorableEdit
extends AbstractUndoableEdit {
    private Restorable changedObject;
    private Object memento;
    private String presentationName;

    public RestorableEdit(Restorable changedObject, Object memento) {
        this(changedObject, memento, "");
    }

    public RestorableEdit(Restorable changedObject, Object memento, String presentationName) {
        this.changedObject = changedObject;
        this.memento = memento;
        this.presentationName = presentationName;
    }

    public Restorable getChangedObject() {
        return this.changedObject;
    }

    @Override
    public String getPresentationName() {
        return this.presentationName;
    }

    @Override
    public void die() {
        super.die();
        this.changedObject = null;
        this.memento = null;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.rememberMemento();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.rememberMemento();
    }

    protected void rememberMemento() {
        Object newMemento = this.changedObject.createMemento();
        this.changedObject.setMemento(this.memento);
        this.memento = newMemento;
    }
}

