/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.core.ExtensionManager;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.FigureTransferable;
import com.bc.ceres.swing.figure.support.StyleDefaults;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultFigureSelection
extends DefaultFigureCollection
implements FigureSelection {
    private List<Handle> handles;
    private Handle selectedHandle;
    private int selectionStage = 0;

    public <E> E getExtension(Class<E> extensionType) {
        return (E)ExtensionManager.getInstance().getExtension((Object)this, extensionType);
    }

    @Override
    public int getSelectionStage() {
        return this.selectionStage;
    }

    @Override
    public void setSelectionStage(int selectionStage) {
        if (this.selectionStage != selectionStage) {
            this.selectionStage = selectionStage;
            if (selectionStage == 0) {
                this.removeAllFigures();
            }
            this.updateHandles();
            this.fireFigureChanged();
        }
    }

    @Override
    public Handle[] getHandles() {
        if (this.handles != null) {
            return this.handles.toArray(new Handle[this.handles.size()]);
        }
        return NO_HANDLES;
    }

    @Override
    public Handle getSelectedHandle() {
        return this.selectedHandle;
    }

    @Override
    public void setSelectedHandle(Handle handle) {
        if (this.selectedHandle != handle) {
            if (this.selectedHandle != null) {
                this.selectedHandle.setSelected(false);
            }
            this.selectedHandle = handle;
            if (this.selectedHandle != null) {
                this.selectedHandle.setSelected(true);
                if (this.handles == null) {
                    this.handles = new ArrayList<Handle>();
                }
                if (!this.handles.contains(handle)) {
                    this.handles.add(this.selectedHandle);
                }
            }
            this.fireFigureChanged();
        }
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean selected) {
    }

    @Override
    public String getPresentationName() {
        return this.getFigureCount() == 0 ? "" : (this.getFigureCount() == 1 ? "Figure" : "Figures");
    }

    @Override
    public Object getSelectedValue() {
        return this.getFigureCount() > 0 ? this.getFigure(0) : null;
    }

    @Override
    public Object[] getSelectedValues() {
        return this.getFigures();
    }

    @Override
    public boolean isEmpty() {
        return this.getFigureCount() == 0;
    }

    @Override
    public Transferable createTransferable(boolean copy) {
        return new FigureTransferable(this.getFigures(), copy);
    }

    @Override
    protected boolean addFigureImpl(int index, Figure figure) {
        if (figure.isSelectable()) {
            figure.setSelected(true);
            return super.addFigureImpl(index, figure);
        }
        return false;
    }

    @Override
    protected Figure[] addFiguresImpl(Figure[] figures) {
        for (Figure figure : figures = DefaultFigureSelection.filterSelectableFigures(figures)) {
            figure.setSelected(true);
        }
        return super.addFiguresImpl(figures);
    }

    @Override
    protected boolean removeFigureImpl(Figure figure) {
        boolean removed = super.removeFigureImpl(figure);
        if (removed) {
            figure.setSelected(false);
        }
        return removed;
    }

    @Override
    protected Figure[] removeFiguresImpl() {
        Figure[] removedFigures;
        for (Figure figure : removedFigures = super.removeFiguresImpl()) {
            figure.setSelected(false);
        }
        return removedFigures;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        FigureTransferable figureTransferable;
        System.out.println("lostOwnership: clipboard = " + clipboard + ", contents = " + contents);
        if (contents instanceof FigureTransferable && (figureTransferable = (FigureTransferable)contents).isSnapshot()) {
            figureTransferable.dispose();
        }
    }

    @Override
    public FigureSelection clone() {
        DefaultFigureSelection figureSelection = (DefaultFigureSelection)super.clone();
        figureSelection.handles = null;
        figureSelection.selectedHandle = null;
        figureSelection.selectionStage = 0;
        return figureSelection;
    }

    public String toString() {
        return this.getClass().getName() + "[figureCount=" + this.getFigureCount() + "]";
    }

    @Override
    public Figure[] removeAllFigures() {
        this.disposeHandles();
        this.selectionStage = 0;
        return super.removeAllFigures();
    }

    @Override
    public void draw(Rendering rendering) {
        if (this.getFigureCount() == 0 || this.getSelectionStage() < 1) {
            return;
        }
        Graphics2D g = rendering.getGraphics();
        Viewport vp = rendering.getViewport();
        AffineTransform m2v = vp.getModelToViewTransform();
        Figure[] figures = this.getFigures();
        if (figures.length > 1) {
            for (int i = 1; i < figures.length; ++i) {
                Figure figure = figures[i];
                g.setPaint(StyleDefaults.MULTI_SELECTION_STROKE_PAINT);
                g.setStroke(StyleDefaults.MULTI_SELECTION_STROKE);
                g.draw(DefaultFigureSelection.getExtendedBounds(figure, m2v));
            }
            g.setPaint(StyleDefaults.SELECTION_STROKE_PAINT);
            g.setStroke(StyleDefaults.FIRST_OF_MULTI_SELECTION_STROKE);
            g.draw(DefaultFigureSelection.getExtendedBounds(figures[0], m2v));
        }
        g.setPaint(StyleDefaults.SELECTION_STROKE_PAINT);
        g.setStroke(StyleDefaults.SELECTION_STROKE);
        g.draw(DefaultFigureSelection.getBounds(this, m2v));
        if (this.handles != null) {
            for (Handle handle : this.handles) {
                handle.draw(rendering);
            }
        }
    }

    private static Rectangle2D getExtendedBounds(Figure figure, AffineTransform m2v) {
        return DefaultFigureSelection.getExtendedBounds(DefaultFigureSelection.getBounds(figure, m2v));
    }

    private static Rectangle2D getBounds(Figure figure, AffineTransform m2v) {
        return m2v.createTransformedShape(figure.getBounds()).getBounds2D();
    }

    static Rectangle2D getExtendedBounds(Rectangle2D bounds) {
        return new Rectangle2D.Double(bounds.getX() - 0.5 * StyleDefaults.SELECTION_EXTEND_SIZE, bounds.getY() - 0.5 * StyleDefaults.SELECTION_EXTEND_SIZE, bounds.getWidth() + StyleDefaults.SELECTION_EXTEND_SIZE, bounds.getHeight() + StyleDefaults.SELECTION_EXTEND_SIZE);
    }

    private void updateHandles() {
        this.disposeHandles();
        if (this.selectionStage != 0) {
            this.handles = new ArrayList<Handle>(Arrays.asList(this.createHandles(this.selectionStage)));
        }
    }

    private void disposeHandles() {
        if (this.handles != null) {
            for (Handle handle : this.handles) {
                handle.dispose();
            }
        }
        this.handles = null;
        this.selectedHandle = null;
    }

    private static Figure[] filterSelectableFigures(Figure[] figures) {
        boolean allSelectable = true;
        for (Figure figure : figures) {
            if (figure.isSelectable()) continue;
            allSelectable = false;
            break;
        }
        if (!allSelectable) {
            ArrayList<Figure> selectableFigures = new ArrayList<Figure>(figures.length);
            for (Figure figure : figures) {
                if (!figure.isSelectable()) continue;
                selectableFigures.add(figure);
            }
            figures = selectableFigures.toArray(new Figure[selectableFigures.size()]);
        }
        return figures;
    }
}

