/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorInteractor;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.Handle;
import com.bc.ceres.swing.figure.support.VertexHandle;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class SelectionInteractor
extends FigureEditorInteractor {
    private final Tool selectPointTool = this.createSelectPointTool();
    private final Tool selectRectangleTool = this.createSelectRectangleTool();
    private final Tool moveSelectionTool = this.createMoveSelectionTool();
    private final Tool moveHandleTool = this.createMoveHandleTool();
    protected boolean canceled;
    protected Point referencePoint;
    private Object figureMemento;
    private Tool tool = new NullTool();

    @Override
    public void cancelInteraction(InputEvent event) {
        if (!this.canceled) {
            this.canceled = true;
            FigureEditor figureEditor = this.getFigureEditor(event);
            if (this.figureMemento != null) {
                figureEditor.getFigureSelection().setMemento(this.figureMemento);
                this.figureMemento = null;
            }
            figureEditor.getFigureSelection().removeAllFigures();
            super.cancelInteraction(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.startInteraction(event)) {
            this.referencePoint = event.getPoint();
            this.canceled = false;
            this.tool = this.selectPointTool;
            this.figureMemento = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (!this.canceled) {
            if (this.tool == this.selectPointTool) {
                this.tool = this.selectHandle(event) ? this.moveHandleTool : (this.isMouseOverSelection(event) ? this.moveSelectionTool : this.selectRectangleTool);
                this.tool.start(event);
            }
            this.tool.drag(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.canceled) {
            this.stopInteraction(event);
            this.tool.end(event);
            this.setCursor(event);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.setCursor(event);
    }

    protected SelectPointTool createSelectPointTool() {
        return new SelectPointTool();
    }

    protected SelectRectangleTool createSelectRectangleTool() {
        return new SelectRectangleTool();
    }

    protected MoveSelectionTool createMoveSelectionTool() {
        return new MoveSelectionTool();
    }

    protected MoveHandleTool createMoveHandleTool() {
        return new MoveHandleTool();
    }

    private void setCursor(MouseEvent event) {
        Cursor cursor = null;
        Handle handle = this.findHandle(event);
        if (handle != null) {
            cursor = handle.getCursor();
        }
        if (cursor == null && this.isMouseOverSelection(event)) {
            cursor = Cursor.getPredefinedCursor(13);
        }
        FigureEditor figureEditor = this.getFigureEditor(event);
        if (cursor == null && figureEditor.getSelectionRectangle() != null) {
            cursor = Cursor.getPredefinedCursor(1);
        }
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        figureEditor.getEditorComponent().setCursor(cursor);
    }

    private Point2D.Double toModelDelta(MouseEvent event) {
        Point2D.Double p = new Point2D.Double(event.getX() - this.referencePoint.x, event.getY() - this.referencePoint.y);
        AffineTransform transform = this.getViewToModelTransform(event);
        transform.deltaTransform(p, p);
        return p;
    }

    private void dragFigure(Figure figure, MouseEvent event) {
        Point2D.Double p = this.toModelDelta(event);
        figure.move(p.getX(), p.getY());
        this.referencePoint = event.getPoint();
    }

    protected boolean isMouseOverSelection(MouseEvent event) {
        return this.getFigureEditor(event).getFigureSelection().isCloseTo(this.toModelPoint(event), this.getModelToViewTransform(event));
    }

    private Figure findFigure(MouseEvent event) {
        return this.getFigureEditor(event).getFigureCollection().getFigure(this.toModelPoint(event), this.getModelToViewTransform(event));
    }

    private Handle findHandle(MouseEvent event) {
        FigureEditor figureEditor = this.getFigureEditor(event);
        FigureSelection figureSelection = figureEditor.getFigureSelection();
        Point2D modelPoint = this.toModelPoint(event);
        AffineTransform m2v = this.getModelToViewTransform(event);
        for (Handle handle : figureSelection.getHandles()) {
            if (!handle.isSelectable() || !handle.isCloseTo(modelPoint, m2v)) continue;
            return handle;
        }
        return null;
    }

    private boolean selectHandle(MouseEvent event) {
        Handle handle = this.findHandle(event);
        if (handle != null) {
            this.getFigureEditor(event).getFigureSelection().setSelectedHandle(handle);
            return true;
        }
        return false;
    }

    protected class SelectRectangleTool
    implements Tool {
        protected SelectRectangleTool() {
        }

        @Override
        public void start(MouseEvent event) {
            SelectionInteractor.this.figureMemento = null;
        }

        @Override
        public void drag(MouseEvent event) {
            int width = event.getX() - SelectionInteractor.this.referencePoint.x;
            int height = event.getY() - SelectionInteractor.this.referencePoint.y;
            int x = SelectionInteractor.this.referencePoint.x;
            int y = SelectionInteractor.this.referencePoint.y;
            if (width < 0) {
                x -= (width *= -1);
            }
            if (height < 0) {
                y -= (height *= -1);
            }
            SelectionInteractor.this.getFigureEditor(event).setSelectionRectangle(new Rectangle(x, y, width, height));
        }

        @Override
        public void end(MouseEvent event) {
            FigureEditor figureEditor = SelectionInteractor.this.getFigureEditor(event);
            if (figureEditor.getSelectionRectangle() != null) {
                AffineTransform transform = SelectionInteractor.this.getViewToModelTransform(event);
                Shape shape = transform.createTransformedShape(figureEditor.getSelectionRectangle());
                if (!event.isControlDown()) {
                    figureEditor.getFigureSelection().removeAllFigures();
                }
                Figure[] figures = figureEditor.getFigureCollection().getFigures(shape);
                figureEditor.getFigureSelection().addFigures(figures);
                if (figureEditor.getFigureSelection().getFigureCount() == 0) {
                    figureEditor.getFigureSelection().setSelectionStage(0);
                } else if (figureEditor.getFigureSelection().getFigureCount() == 1) {
                    figureEditor.getFigureSelection().setSelectionStage(1);
                } else {
                    figureEditor.getFigureSelection().setSelectionStage(2);
                }
                figureEditor.setSelectionRectangle(null);
            }
        }
    }

    protected class SelectPointTool
    implements Tool {
        protected SelectPointTool() {
        }

        @Override
        public void start(MouseEvent event) {
            SelectionInteractor.this.figureMemento = null;
        }

        @Override
        public void drag(MouseEvent event) {
        }

        @Override
        public void end(MouseEvent event) {
            if (SelectionInteractor.this.selectHandle(event)) {
                return;
            }
            Figure clickedFigure = SelectionInteractor.this.findFigure(event);
            FigureEditor figureEditor = SelectionInteractor.this.getFigureEditor(event);
            if (clickedFigure == null) {
                figureEditor.getFigureSelection().removeAllFigures();
                figureEditor.getFigureSelection().setSelectionStage(0);
            } else if (figureEditor.getFigureSelection().getFigureCount() == 0) {
                figureEditor.getFigureSelection().addFigure(clickedFigure);
                figureEditor.getFigureSelection().setSelectionStage(1);
            } else if (figureEditor.getFigureSelection().getFigureCount() == 1) {
                if (figureEditor.getFigureSelection().contains(clickedFigure)) {
                    int selectionLevel = figureEditor.getFigureSelection().getSelectionStage() + 1;
                    if (selectionLevel > clickedFigure.getMaxSelectionStage()) {
                        selectionLevel = 0;
                    }
                    figureEditor.getFigureSelection().setSelectionStage(selectionLevel);
                } else if (event.isControlDown()) {
                    figureEditor.getFigureSelection().addFigure(clickedFigure);
                    figureEditor.getFigureSelection().setSelectionStage(2);
                } else {
                    figureEditor.getFigureSelection().removeAllFigures();
                    figureEditor.getFigureSelection().addFigure(clickedFigure);
                    figureEditor.getFigureSelection().setSelectionStage(1);
                }
            } else if (figureEditor.getFigureSelection().getFigureCount() >= 2) {
                if (figureEditor.getFigureSelection().contains(clickedFigure)) {
                    if (event.isControlDown()) {
                        figureEditor.getFigureSelection().removeFigure(clickedFigure);
                    }
                } else if (event.isControlDown()) {
                    figureEditor.getFigureSelection().addFigure(clickedFigure);
                } else {
                    figureEditor.getFigureSelection().removeAllFigures();
                    figureEditor.getFigureSelection().addFigure(clickedFigure);
                }
                figureEditor.getFigureSelection().setSelectionStage(2);
            }
        }
    }

    protected class MoveHandleTool
    implements Tool {
        protected MoveHandleTool() {
        }

        @Override
        public void start(MouseEvent event) {
            SelectionInteractor.this.figureMemento = SelectionInteractor.this.getFigureEditor(event).getFigureSelection().createMemento();
            if (event.isControlDown()) {
                this.maybeAddSegment(event);
            }
        }

        @Override
        public void drag(MouseEvent event) {
            Handle selectedHandle = SelectionInteractor.this.getFigureEditor(event).getFigureSelection().getSelectedHandle();
            SelectionInteractor.this.dragFigure(selectedHandle, event);
        }

        @Override
        public void end(MouseEvent event) {
            if (event.isControlDown()) {
                this.maybeRemoveSegment(event);
            }
            FigureEditor figureEditor = SelectionInteractor.this.getFigureEditor(event);
            figureEditor.getFigureSelection().setSelectedHandle(null);
            figureEditor.changeFigure(figureEditor.getFigureSelection(), SelectionInteractor.this.figureMemento, "Change Figure Shape");
        }

        private void maybeAddSegment(MouseEvent event) {
            FigureSelection figureSelection = SelectionInteractor.this.getFigureEditor(event).getFigureSelection();
            Handle selectedHandle = figureSelection.getSelectedHandle();
            if (selectedHandle instanceof VertexHandle) {
                VertexHandle selectedVertexHandle = (VertexHandle)selectedHandle;
                int segmentIndex = selectedVertexHandle.getSegmentIndex();
                Figure figure = figureSelection.getFigure(0);
                double[] segment = figure.getSegment(segmentIndex);
                segment[0] = segment[0] + 0.1;
                segment[1] = segment[1] + 0.1;
                figure.addSegment(segmentIndex, segment);
                VertexHandle newVertexHandle = new VertexHandle(figure, segmentIndex, selectedVertexHandle.getNormalStyle(), selectedVertexHandle.getSelectedStyle());
                figureSelection.setSelectedHandle(newVertexHandle);
                for (Handle handle : figureSelection.getHandles()) {
                    VertexHandle vertexHandle;
                    if (!(handle instanceof VertexHandle) || (vertexHandle = (VertexHandle)handle) == newVertexHandle || vertexHandle.getSegmentIndex() < segmentIndex) continue;
                    vertexHandle.setSegmentIndex(vertexHandle.getSegmentIndex() + 1);
                }
            }
        }

        private void maybeRemoveSegment(MouseEvent event) {
            FigureSelection figureSelection = SelectionInteractor.this.getFigureEditor(event).getFigureSelection();
            Handle selectedHandle = figureSelection.getSelectedHandle();
            if (selectedHandle instanceof VertexHandle) {
                VertexHandle selectedVertexHandle = (VertexHandle)selectedHandle;
                AffineTransform m2v = SelectionInteractor.this.getModelToViewTransform(event);
                Point2D p1 = m2v.transform(selectedVertexHandle.getLocation(), null);
                int segmentIndex = selectedVertexHandle.getSegmentIndex();
                Figure figure = figureSelection.getFigure(0);
                for (Handle handle : figureSelection.getHandles()) {
                    if (!(handle instanceof VertexHandle)) continue;
                    VertexHandle vertexHandle = (VertexHandle)handle;
                    Point2D p2 = m2v.transform(vertexHandle.getLocation(), null);
                    if (vertexHandle.getSegmentIndex() != segmentIndex - 1 && vertexHandle.getSegmentIndex() != segmentIndex + 1 || !vertexHandle.getShape().contains(new Point2D.Double(p1.getX() - p2.getX(), p1.getY() - p2.getY()))) continue;
                    figure.removeSegment(segmentIndex);
                }
            }
        }
    }

    protected class MoveSelectionTool
    implements Tool {
        protected MoveSelectionTool() {
        }

        @Override
        public void start(MouseEvent event) {
            SelectionInteractor.this.figureMemento = SelectionInteractor.this.getFigureEditor(event).getFigureSelection().createMemento();
        }

        @Override
        public void drag(MouseEvent event) {
            SelectionInteractor.this.dragFigure(SelectionInteractor.this.getFigureEditor(event).getFigureSelection(), event);
        }

        @Override
        public void end(MouseEvent event) {
            FigureEditor figureEditor = SelectionInteractor.this.getFigureEditor(event);
            figureEditor.changeFigure(figureEditor.getFigureSelection(), SelectionInteractor.this.figureMemento, "Move Figure");
        }
    }

    private static class NullTool
    implements Tool {
        private NullTool() {
        }

        @Override
        public void start(MouseEvent event) {
        }

        @Override
        public void drag(MouseEvent event) {
        }

        @Override
        public void end(MouseEvent event) {
        }
    }

    protected static interface Tool {
        public void start(MouseEvent var1);

        public void drag(MouseEvent var1);

        public void end(MouseEvent var1);
    }
}

