/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorInteractor;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.ShapeFigure;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class InsertMultiPointFigureInteractor
extends FigureEditorInteractor {
    private final List<Point2D> points;
    private final boolean polygonal;
    private ShapeFigure figure;
    private boolean started;

    public InsertMultiPointFigureInteractor(boolean polygonal) {
        this.polygonal = polygonal;
        this.points = new ArrayList<Point2D>(8);
    }

    public boolean isPolygonal() {
        return this.polygonal;
    }

    @Override
    public void cancelInteraction(InputEvent event) {
        this.started = false;
        if (!this.points.isEmpty()) {
            this.points.remove(this.points.size() - 1);
            this.points.remove(this.points.size() - 1);
            if (this.points.isEmpty()) {
                this.getFigureEditor(event).getFigureCollection().removeFigure(this.figure);
                this.figure = null;
            } else {
                this.figure.setShape(this.createPath());
            }
            super.cancelInteraction(event);
        }
    }

    @Override
    protected void stopInteraction(InputEvent inputEvent) {
        super.stopInteraction(inputEvent);
        this.started = false;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.started && event.getClickCount() > 1) {
            if (this.points.isEmpty()) {
                this.getFigureEditor(event).getFigureCollection().removeFigure(this.figure);
                this.figure = null;
            } else {
                FigureEditor figureEditor = this.getFigureEditor(event);
                figureEditor.getFigureSelection().removeAllFigures();
                if (this.isPolygonal()) {
                    this.removeNotNeededPoints();
                }
                this.figure.setShape(this.createPath());
                this.points.clear();
                figureEditor.insertFigures(false, this.figure);
                this.stopInteraction(event);
            }
        }
    }

    private void removeNotNeededPoints() {
        int moreThanFour = this.points.size() - 4;
        for (int i = Math.min(2, moreThanFour); i > 0; --i) {
            this.points.remove(0);
        }
        this.points.remove(this.points.size() - 1);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (!this.started) {
            this.started = this.startInteraction(event);
        }
        if (!this.started) {
            return;
        }
        FigureEditor figureEditor = this.getFigureEditor(event);
        boolean startingNewFigure = false;
        if (this.points.isEmpty()) {
            figureEditor.getFigureSelection().removeAllFigures();
            startingNewFigure = true;
        }
        if (!startingNewFigure) {
            this.points.remove(this.points.size() - 1);
        }
        this.points.add(this.toModelPoint(event));
        this.points.add(this.toModelPoint(event));
        if (this.isPolygonal() && startingNewFigure) {
            this.points.add(this.toModelPoint(event));
            this.points.add(this.toModelPoint(event));
        }
        if (startingNewFigure) {
            FigureFactory factory = figureEditor.getFigureFactory();
            this.figure = this.isPolygonal() ? factory.createPolygonFigure(this.createPath(), figureEditor.getDefaultPolygonStyle()) : factory.createLineFigure(this.createPath(), figureEditor.getDefaultLineStyle());
            figureEditor.getFigureCollection().addFigure(this.figure);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.started && !this.points.isEmpty()) {
            this.points.set(this.points.size() - 1, this.toModelPoint(event));
            this.figure.setShape(this.createPath());
        }
    }

    protected Path2D createPath() {
        Point2D[] points = this.getPoints();
        Path2D.Double path = new Path2D.Double();
        path.moveTo(points[0].getX(), points[0].getY());
        for (int i = 1; i < points.length; ++i) {
            path.lineTo(points[i].getX(), points[i].getY());
        }
        if (this.isPolygonal()) {
            path.closePath();
        }
        return path;
    }

    protected Point2D[] getPoints() {
        return this.points.toArray(new Point2D[this.points.size()]);
    }
}

