/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.demo;

import com.bc.ceres.glayer.swing.AdjustableViewScrollPane;
import com.bc.ceres.grender.AdjustableView;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.DefaultViewport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;

public class FocusApp {
    static int frameNo = 1;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        MyJPanel panel = new MyJPanel();
        panel.setPreferredSize(new Dimension(512, 512));
        AdjustableViewScrollPane viewScrollPane = new AdjustableViewScrollPane((JComponent)panel);
        JFrame jFrame = new JFrame("x");
        jFrame.add((Component)viewScrollPane);
        JTree tree1 = new JTree(new Object[]{"Aaaaaaaaaaaaa", "B", "C"});
        JTree tree2 = new JTree(new Object[]{"Xxxxxxxxxxxxx", "Y", "Z"});
        tree1.setCellRenderer(new MyDefaultTreeCellRenderer());
        tree2.setCellRenderer(new MyDefaultTreeCellRenderer());
        tree1.addFocusListener(new MyFocusListener());
        tree2.addFocusListener(new MyFocusListener());
        FocusApp.showFrame(tree1);
        FocusApp.showFrame(tree2);
        JList<Object> list1 = new JList<Object>(new Object[]{"Aaaaaaaaaaaaa", "B", "C"});
        JList<Object> list2 = new JList<Object>(new Object[]{"Xxxxxxxxxxxxx", "Y", "Z"});
        list1.setCellRenderer(new MyDefaultListCellRenderer());
        list2.setCellRenderer(new MyDefaultListCellRenderer());
        list1.addFocusListener(new MyFocusListener());
        list2.addFocusListener(new MyFocusListener());
        FocusApp.showFrame(list1);
        FocusApp.showFrame(list2);
    }

    private static void showUIDefaults() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        Object[] keys = uiDefaults.keySet().toArray();
        Arrays.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Object[][] tableData = new Object[keys.length][2];
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            Object value = uiDefaults.get(key);
            System.out.println(key + " = " + value);
            tableData[i][0] = key.toString();
            tableData[i][1] = value;
        }
        JTable table = new JTable(tableData, new String[]{"Key", "Value"});
        table.getColumnModel().getColumn(1).setCellRenderer(new MyDefaultTableCellRenderer());
        JFrame jFrame = new JFrame("LookAndFeelDefaults");
        jFrame.add(new JScrollPane(table));
        jFrame.setBounds(100, 100, 400, 400);
        jFrame.setVisible(true);
    }

    private static void showFrame(JComponent component) {
        final JFrame frame = new JFrame("FocusApp-" + frameNo++);
        frame.setDefaultCloseOperation(3);
        frame.add((Component)component, "Center");
        frame.setBounds(10, 10, 400, 100);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    private static class MyJPanel
    extends JPanel
    implements AdjustableView {
        private DefaultViewport viewport = new DefaultViewport();

        public MyJPanel() {
            super(new BorderLayout());
        }

        public Rectangle2D getMaxVisibleModelBounds() {
            return null;
        }

        public double getDefaultZoomFactor() {
            return 0.0;
        }

        public double getMinZoomFactor() {
            return 0.1;
        }

        public double getMaxZoomFactor() {
            return 10.0;
        }

        public Viewport getViewport() {
            return this.viewport;
        }
    }

    private static class MyDefaultTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyDefaultTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            this.setBackground(Color.WHITE);
            this.setText(value != null ? value.toString() : "null");
            this.setBorder(null);
            this.setIcon(null);
            if (value instanceof UIResource) {
                if (value instanceof Color) {
                    Color color = (Color)value;
                    this.setBackground(color);
                    this.setBorder(new LineBorder(Color.WHITE, 2));
                } else if (value instanceof Font) {
                    Font font = (Font)value;
                    this.setBackground(Color.WHITE);
                    this.setFont(font);
                } else if (value instanceof Icon) {
                    Icon icon = (Icon)value;
                } else if (value instanceof Border) {
                    Border border = (Border)value;
                }
            }
            return this;
        }
    }

    private static class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            e.getComponent().repaint();
        }
    }

    private static class MyDefaultTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private MyDefaultTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Window window = SwingUtilities.getWindowAncestor(tree);
            if (window != null && !window.isFocused()) {
                hasFocus = isSelected;
                isSelected = false;
            }
            return super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, hasFocus);
        }
    }

    private static class MyDefaultListCellRenderer
    extends DefaultListCellRenderer {
        private MyDefaultListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Window window = SwingUtilities.getWindowAncestor(list);
            if (window != null && !window.isFocused()) {
                hasFocus = isSelected;
                isSelected = false;
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
        }
    }
}

