/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.demo;

import com.bc.ceres.glayer.swing.AdjustableViewScrollPane;
import com.bc.ceres.swing.actions.CopyAction;
import com.bc.ceres.swing.actions.CutAction;
import com.bc.ceres.swing.actions.DeleteAction;
import com.bc.ceres.swing.actions.PasteAction;
import com.bc.ceres.swing.actions.RedoAction;
import com.bc.ceres.swing.actions.SelectAllAction;
import com.bc.ceres.swing.actions.UndoAction;
import com.bc.ceres.swing.figure.AbstractInteractorListener;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureFactory;
import com.bc.ceres.swing.figure.Interactor;
import com.bc.ceres.swing.figure.interactions.InsertEllipseFigureInteractor;
import com.bc.ceres.swing.figure.interactions.InsertLineFigureInteractor;
import com.bc.ceres.swing.figure.interactions.InsertPolygonFigureInteractor;
import com.bc.ceres.swing.figure.interactions.InsertPolylineFigureInteractor;
import com.bc.ceres.swing.figure.interactions.InsertRectangleFigureInteractor;
import com.bc.ceres.swing.figure.interactions.PanInteractor;
import com.bc.ceres.swing.figure.interactions.SelectionInteractor;
import com.bc.ceres.swing.figure.interactions.ZoomInteractor;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.FigureEditorPanel;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.support.DefaultSelectionManager;
import com.bc.ceres.swing.undo.support.DefaultUndoContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;

public abstract class FigureEditorApp {
    private static final Interactor SELECTION_INTERACTOR = new SelectionInteractor();
    private static final Interactor ZOOM_INTERACTOR = new ZoomInteractor();
    private static final Interactor PAN_INTERACTOR = new PanInteractor();
    private static final Interactor NEW_LINE_INTERACTOR = new InsertLineFigureInteractor();
    private static final Interactor NEW_RECT_INTERACTOR = new InsertRectangleFigureInteractor();
    private static final Interactor NEW_ELLI_INTERACTOR = new InsertEllipseFigureInteractor();
    private static final Interactor NEW_POLYLINE_INTERACTOR = new InsertPolylineFigureInteractor();
    private static final Interactor NEW_POLYGON_INTERACTOR = new InsertPolygonFigureInteractor();
    private JFrame frame;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private DeleteAction deleteAction;
    private SelectAllAction selectAllAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private FigureEditorPanel figureEditorPanel;

    protected FigureEditorApp() {
    }

    protected abstract FigureFactory getFigureFactory();

    protected abstract void loadFigureCollection(File var1, FigureCollection var2) throws IOException;

    protected abstract void storeFigureCollection(FigureCollection var1, File var2) throws IOException;

    private void init() {
        DefaultSelectionManager selectionManager = new DefaultSelectionManager();
        DefaultUndoContext undoContext = new DefaultUndoContext(this);
        this.figureEditorPanel = new FigureEditorPanel(undoContext, new DefaultFigureCollection(), this.getFigureFactory());
        selectionManager.setSelectionContext(this.figureEditorPanel.getFigureEditor().getSelectionContext());
        this.undoAction = new UndoAction(undoContext){

            @Override
            public void execute() {
                super.execute();
                FigureEditorApp.this.redoAction.updateState();
            }
        };
        this.redoAction = new RedoAction(undoContext){

            @Override
            public void execute() {
                super.execute();
                FigureEditorApp.this.undoAction.updateState();
            }
        };
        this.cutAction = new CutAction(selectionManager);
        this.copyAction = new CopyAction(selectionManager);
        this.pasteAction = new PasteAction(selectionManager);
        this.selectAllAction = new SelectAllAction(selectionManager);
        this.deleteAction = new DeleteAction(selectionManager);
        AbstractButton selectButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "S", SELECTION_INTERACTOR);
        AbstractButton zoomButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "Z", ZOOM_INTERACTOR);
        AbstractButton panButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "P", PAN_INTERACTOR);
        AbstractButton newLineButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "L", NEW_LINE_INTERACTOR);
        AbstractButton newRectButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "R", NEW_RECT_INTERACTOR);
        AbstractButton newElliButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "E", NEW_ELLI_INTERACTOR);
        AbstractButton newPLButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "PL", NEW_POLYLINE_INTERACTOR);
        AbstractButton newPGButton = FigureEditorApp.createInteractorButton(this.figureEditorPanel, "PG", NEW_POLYGON_INTERACTOR);
        JToolBar toolBar = new JToolBar();
        toolBar.add(selectButton);
        toolBar.add(zoomButton);
        toolBar.add(panButton);
        toolBar.add(newLineButton);
        toolBar.add(newRectButton);
        toolBar.add(newElliButton);
        toolBar.add(newPLButton);
        toolBar.add(newPGButton);
        ButtonGroup group = new ButtonGroup();
        group.add(selectButton);
        group.add(zoomButton);
        group.add(panButton);
        group.add(newLineButton);
        group.add(newRectButton);
        group.add(newElliButton);
        group.add(newPLButton);
        group.add(newPGButton);
        this.figureEditorPanel.getFigureEditor().setInteractor(SELECTION_INTERACTOR);
        this.figureEditorPanel.setPreferredSize(new Dimension(1024, 1024));
        FigureCollection drawing = this.figureEditorPanel.getFigureEditor().getFigureCollection();
        FigureFactory figureFactory = this.figureEditorPanel.getFigureEditor().getFigureFactory();
        drawing.addFigure(figureFactory.createPolygonFigure(new Rectangle(20, 30, 200, 100), DefaultFigureStyle.createPolygonStyle(Color.BLUE, Color.GREEN)));
        drawing.addFigure(figureFactory.createPolygonFigure(new Rectangle(90, 10, 100, 200), DefaultFigureStyle.createPolygonStyle(Color.MAGENTA, Color.ORANGE)));
        Path2D linePath = FigureEditorApp.rectPath(true, 110, 60, 70, 140);
        drawing.addFigure(figureFactory.createLineFigure(linePath, DefaultFigureStyle.createLineStyle(Color.GRAY)));
        linePath = new Path2D.Double();
        linePath.moveTo(110.0, 60.0);
        linePath.lineTo(180.0, 60.0);
        linePath.lineTo(180.0, 200.0);
        drawing.addFigure(figureFactory.createLineFigure(linePath, DefaultFigureStyle.createLineStyle(Color.BLACK)));
        linePath = new Path2D.Double();
        linePath.moveTo(200.0, 100.0);
        linePath.lineTo(300.0, 200.0);
        drawing.addFigure(figureFactory.createLineFigure(linePath, DefaultFigureStyle.createLineStyle(Color.MAGENTA, new BasicStroke(5.0f))));
        drawing.addFigure(figureFactory.createPolygonFigure(new Ellipse2D.Double(50.0, 100.0, 80.0, 80.0), DefaultFigureStyle.createPolygonStyle(Color.YELLOW, Color.RED)));
        drawing.addFigure(figureFactory.createPolygonFigure(new Ellipse2D.Double(220.0, 120.0, 150.0, 300.0), DefaultFigureStyle.createPolygonStyle(Color.GREEN, Color.BLUE)));
        Area area = new Area(new Rectangle(0, 0, 100, 100));
        area.subtract(new Area(new Rectangle(25, 25, 50, 50)));
        area.add(new Area(new Rectangle(75, 75, 50, 50)));
        area.subtract(new Area(new Rectangle(87, 87, 25, 25)));
        area.subtract(new Area(new Rectangle(-26, -26, 50, 50)));
        Path2D.Double path = new Path2D.Double(0);
        path.append(FigureEditorApp.rectPath(true, 0, 0, 100, 100), false);
        path.append(FigureEditorApp.rectPath(false, 12, 12, 25, 25), false);
        path.append(FigureEditorApp.rectPath(false, 65, 65, 25, 25), false);
        DefaultFigureStyle shapeStyle = DefaultFigureStyle.createPolygonStyle(new Color(0, 0, 255, 127), Color.ORANGE);
        drawing.addFigure(figureFactory.createPolygonFigure(path, shapeStyle));
        for (int i = 0; i < 50; ++i) {
            DefaultFigureStyle pointStyle = new DefaultFigureStyle();
            pointStyle.setStrokeColor(new Color(0, 0, 64));
            pointStyle.setStrokeOpacity(0.9);
            pointStyle.setStrokeWidth(1.0);
            int type = i % 4;
            if (type == 0) {
                pointStyle.setSymbolName("pin");
                pointStyle.setFillColor(new Color(128, 128, 255));
                pointStyle.setFillOpacity(0.7);
            } else if (type == 1) {
                pointStyle.setSymbolName("circle");
                pointStyle.setFillColor(new Color(128, 128, 0));
                pointStyle.setFillOpacity(0.7);
            } else if (type == 2) {
                pointStyle.setSymbolName("star");
            } else {
                pointStyle.setSymbolImagePath("/com/bc/ceres/swing/update/icons/list-add.png");
                pointStyle.setSymbolRefX(8.0);
                pointStyle.setSymbolRefY(8.0);
            }
            drawing.addFigure(figureFactory.createPointFigure(new Point2D.Double(i * 10, i * 10), pointStyle));
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createEditMenu());
        AdjustableViewScrollPane contentPane = new AdjustableViewScrollPane((JComponent)this.figureEditorPanel);
        this.frame = new JFrame(this.getClass().getSimpleName());
        this.frame.setDefaultCloseOperation(3);
        this.frame.setJMenuBar(menuBar);
        this.frame.getContentPane().add((Component)toolBar, "North");
        this.frame.getContentPane().add((Component)contentPane, "Center");
        this.frame.setSize(400, 400);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                String message = MessageFormat.format("An internal error occurred!\nType: {0}\nMessage: {1}", e.getClass(), e.getMessage());
                JOptionPane.showMessageDialog(FigureEditorApp.this.frame, message, "Internal Error", 0);
                System.exit(1);
            }
        });
        this.figureEditorPanel.getFigureEditor().getSelectionContext().addSelectionChangeListener(new SelectionChangeListener(){

            @Override
            public void selectionChanged(SelectionChangeEvent event) {
                System.out.println("selection changed: " + event.getSelection());
            }

            @Override
            public void selectionContextChanged(SelectionChangeEvent event) {
                System.out.println("selection context changed: " + event.getSelection());
            }
        });
        undoContext.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent event) {
                System.out.println("edit happened: " + event.getEdit());
            }
        });
        selectionManager.getClipboard().addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent event) {
                System.out.println("flavors changed: " + event);
            }
        });
    }

    private static Path2D rectPath(boolean clockwise, int x, int y, int w, int h) {
        Path2D.Double linePath = new Path2D.Double();
        linePath.moveTo(x, y);
        if (clockwise) {
            linePath.lineTo(x, y + h);
            linePath.lineTo(x + w, y + h);
            linePath.lineTo(x + w, y);
        } else {
            linePath.lineTo(x + w, y);
            linePath.lineTo(x + w, y + h);
            linePath.lineTo(x, y + h);
        }
        linePath.lineTo(x, y);
        linePath.closePath();
        return linePath;
    }

    public static void run(FigureEditorApp drawingApp) {
        drawingApp.init();
        drawingApp.run();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    private void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FigureEditorApp.this.frame.setVisible(true);
            }
        });
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.add(new OpenAction());
        menu.add(new SaveAsAction());
        menu.addSeparator();
        menu.add(new ExitAction());
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.add(this.undoAction);
        menu.add(this.redoAction);
        menu.addSeparator();
        menu.add(this.cutAction);
        menu.add(this.copyAction);
        menu.add(this.pasteAction);
        menu.addSeparator();
        menu.add(this.selectAllAction);
        menu.addSeparator();
        menu.add(this.deleteAction);
        return menu;
    }

    private static AbstractButton createInteractorButton(final FigureEditorPanel figureEditorPanel, String name, final Interactor interactor) {
        final JToggleButton selectButton = new JToggleButton(name);
        selectButton.setSelected(false);
        selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = selectButton.isSelected();
                System.out.println("b = " + b);
                if (b) {
                    figureEditorPanel.getFigureEditor().setInteractor(interactor);
                }
            }
        });
        interactor.addListener(new AbstractInteractorListener(){

            @Override
            public void interactorActivated(Interactor interactor) {
                selectButton.setSelected(true);
            }

            @Override
            public void interactorDeactivated(Interactor interactor) {
                selectButton.setSelected(false);
            }
        });
        return selectButton;
    }

    static {
        Locale.setDefault(Locale.ENGLISH);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ExitAction
    extends AbstractAction {
        private ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ActionCommandKey", this.getClass().getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FigureEditorApp.this.frame.dispose();
        }
    }

    private class SaveAsAction
    extends AbstractAction {
        private SaveAsAction() {
            this.putValue("Name", "Save As...");
            this.putValue("ActionCommandKey", this.getClass().getName());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File lastDir = new File(Preferences.userNodeForPackage(FigureEditorApp.class).get("lastDir", "."));
            JFileChooser chooser = new JFileChooser(lastDir);
            chooser.setAcceptAllFileFilterUsed(true);
            int i = chooser.showSaveDialog(FigureEditorApp.this.frame);
            if (i == 0 && chooser.getSelectedFile() != null) {
                Preferences.userNodeForPackage(FigureEditorApp.class).put("lastDir", chooser.getCurrentDirectory().getPath());
                try {
                    FigureEditorApp.this.storeFigureCollection(FigureEditorApp.this.figureEditorPanel.getFigureEditor().getFigureCollection(), chooser.getSelectedFile());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(FigureEditorApp.this.getFrame(), "Error: " + e.getMessage());
                }
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        private OpenAction() {
            this.putValue("Name", "Open...");
            this.putValue("ActionCommandKey", this.getClass().getName());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            File lastDir = new File(Preferences.userNodeForPackage(FigureEditorApp.class).get("lastDir", "."));
            JFileChooser chooser = new JFileChooser(lastDir);
            chooser.setAcceptAllFileFilterUsed(true);
            int i = chooser.showOpenDialog(FigureEditorApp.this.frame);
            if (i == 0 && chooser.getSelectedFile() != null) {
                Preferences.userNodeForPackage(FigureEditorApp.class).put("lastDir", chooser.getCurrentDirectory().getPath());
                FigureEditorApp.this.figureEditorPanel.getFigureEditor().getFigureSelection().removeAllFigures();
                FigureEditorApp.this.figureEditorPanel.getFigureEditor().getFigureCollection().removeAllFigures();
                try {
                    FigureEditorApp.this.loadFigureCollection(chooser.getSelectedFile(), FigureEditorApp.this.figureEditorPanel.getFigureEditor().getFigureCollection());
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(FigureEditorApp.this.getFrame(), "Error: " + e.getMessage());
                }
            }
        }
    }
}

