/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing;

import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.GridSelectionModel;
import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class Grid
extends JPanel
implements GridSelectionModel.Listener {
    private final List<List<JComponent>> componentRows;
    private final JPanel filler;
    private GridSelectionModel selectionModel;
    private boolean showSelectionColumn;
    private int lastFillerRow = -1;

    public Grid(int columnCount, boolean showSelectionColumn) {
        this(new TableLayout(columnCount), showSelectionColumn);
    }

    public Grid(TableLayout tableLayout, boolean showSelectionColumn) {
        super(tableLayout);
        this.showSelectionColumn = showSelectionColumn;
        this.componentRows = new ArrayList<List<JComponent>>();
        this.componentRows.add(new ArrayList<JComponent>(Arrays.asList(new JComponent[tableLayout.getColumnCount()])));
        this.selectionModel = new DefaultGridSelectionModel();
        this.selectionModel.addListener(this);
        this.filler = new JPanel();
        this.addFiller();
    }

    @Override
    public TableLayout getLayout() {
        return (TableLayout)super.getLayout();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        TableLayout oldLayout = this.getLayout();
        if (oldLayout == mgr) {
            return;
        }
        if (!(mgr instanceof TableLayout)) {
            throw new IllegalArgumentException();
        }
        TableLayout tableLayout = (TableLayout)mgr;
        if (oldLayout != null && oldLayout.getColumnCount() != tableLayout.getColumnCount() && this.getRowCount() > 0) {
            throw new IllegalArgumentException();
        }
        super.setLayout(tableLayout);
    }

    public GridSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(GridSelectionModel selectionModel) {
        GridSelectionModel oldSelectionModel = this.selectionModel;
        if (oldSelectionModel != selectionModel) {
            if (oldSelectionModel != null) {
                oldSelectionModel.removeListener(this);
            }
            this.selectionModel = selectionModel;
            if (this.selectionModel != null) {
                this.selectionModel.addListener(this);
            }
            this.firePropertyChange("selectionModel", oldSelectionModel, this.selectionModel);
        }
    }

    public boolean getShowSelectionColumn() {
        return this.showSelectionColumn;
    }

    public void setShowSelectionColumn(boolean showSelectionColumn) {
        boolean oldShowSelectionColumn = this.showSelectionColumn;
        if (oldShowSelectionColumn != showSelectionColumn) {
            this.showSelectionColumn = showSelectionColumn;
            for (List<JComponent> componentRow : this.componentRows) {
                JComponent component = componentRow.get(0);
                if (component == null) continue;
                component.setVisible(this.showSelectionColumn);
            }
            this.fireComponentsChanged();
            this.firePropertyChange("showSelectionColumn", oldShowSelectionColumn, showSelectionColumn);
        }
    }

    public int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public int getDataColumnCount() {
        return this.getColumnCount() - 1;
    }

    public int getRowCount() {
        return this.componentRows.size();
    }

    public int getDataRowCount() {
        return this.getRowCount() - 1;
    }

    public JComponent getComponent(int rowIndex, int colIndex) {
        return this.componentRows.get(rowIndex).get(colIndex);
    }

    public JComponent setComponent(int rowIndex, int colIndex, JComponent component) {
        List<JComponent> componentRow = this.componentRows.get(rowIndex);
        JComponent oldComponent = componentRow.get(colIndex);
        if (oldComponent != null) {
            this.remove(oldComponent);
        }
        if (component != null) {
            this.add((Component)component, TableLayout.cell(rowIndex, colIndex));
        }
        componentRow.set(colIndex, component);
        this.fireComponentsChanged();
        return oldComponent;
    }

    public int findRowIndex(JComponent component) {
        return this.findRowIndex(component, 0);
    }

    public int findDataRowIndex(JComponent component) {
        int rowIndex = this.findRowIndex(component, 1);
        return rowIndex >= 1 ? rowIndex - 1 : -1;
    }

    public void setHeaderRow(JComponent ... components) {
        this.checkColumnCount(components);
        ArrayList<JComponent> headerRow = new ArrayList<JComponent>(components.length + 1);
        AbstractButton headerRowSelector = this.createHeaderRowSelector();
        if (headerRowSelector != null) {
            headerRowSelector.setVisible(this.showSelectionColumn);
            headerRowSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Grid.this.onHeaderRowSelectorAction();
                }
            });
        }
        headerRow.add(headerRowSelector);
        Collections.addAll(headerRow, components);
        this.addComponentRowIntern(headerRow, 0);
        this.componentRows.set(0, headerRow);
        this.fireComponentsChanged();
        this.adjustHeaderRowSelector();
    }

    public JComponent[] getDataRow(int dataRowIndex) {
        Assert.argument((dataRowIndex >= 0 && dataRowIndex < this.getDataRowCount() ? 1 : 0) != 0, (String)"dataRowIndex");
        int rowIndex = dataRowIndex + 1;
        List<JComponent> componentRow = this.componentRows.get(rowIndex);
        JComponent[] dataRow = new JComponent[this.getDataColumnCount()];
        for (int i = 0; i < dataRow.length; ++i) {
            dataRow[i] = componentRow.get(i + 1);
        }
        return dataRow;
    }

    public void addDataRow(JComponent ... components) {
        this.checkColumnCount(components);
        this.removeFiller();
        ArrayList<JComponent> dataRow = new ArrayList<JComponent>(components.length + 1);
        AbstractButton dataRowSelector = this.createDataRowSelector();
        if (dataRowSelector != null) {
            dataRowSelector.setVisible(this.showSelectionColumn);
            dataRowSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Grid.this.onDataRowSelectorAction();
                }
            });
        }
        dataRow.add(dataRowSelector);
        Collections.addAll(dataRow, components);
        this.addComponentRowIntern(dataRow, this.componentRows.size());
        this.componentRows.add(dataRow);
        this.addFiller();
        this.fireComponentsChanged();
        this.adjustHeaderRowSelector();
    }

    public void removeDataRow(int dataRowIndex) {
        Assert.argument((dataRowIndex >= 0 ? 1 : 0) != 0, (String)"dataRowIndex");
        int rowIndex = dataRowIndex + 1;
        this.removeFiller();
        boolean rowSelected = this.isDataRowSelected(rowIndex);
        List<JComponent> componentRow = this.componentRows.get(rowIndex);
        this.removeComponentRowIntern(componentRow);
        this.componentRows.remove(rowIndex);
        for (int i = rowIndex; i < this.componentRows.size(); ++i) {
            this.addComponentRowIntern(this.componentRows.get(i), i);
        }
        this.addFiller();
        this.fireComponentsChanged();
        if (rowSelected) {
            this.selectionModel.removeSelectedRowIndex(dataRowIndex);
        }
    }

    public void removeDataRows(int ... dataRowIndexes) {
        int rowIndex0;
        if (dataRowIndexes.length == 0) {
            return;
        }
        this.removeFiller();
        int offset = 0;
        int selectedCount = 0;
        for (int dataRowIndex : dataRowIndexes) {
            Assert.argument((dataRowIndex >= 0 ? 1 : 0) != 0, (String)"rowIndexes");
            int rowIndex = dataRowIndex + 1 - offset;
            Assert.state((rowIndex >= 1 ? 1 : 0) != 0, (String)"rowIndex");
            selectedCount += this.isDataRowSelected(dataRowIndex) ? 1 : 0;
            List<JComponent> componentRow = this.componentRows.get(rowIndex);
            this.removeComponentRowIntern(componentRow);
            this.componentRows.remove(rowIndex);
            ++offset;
        }
        for (int rowIndex = rowIndex0 = dataRowIndexes[0] + 1; rowIndex < this.componentRows.size(); ++rowIndex) {
            this.addComponentRowIntern(this.componentRows.get(rowIndex), rowIndex);
        }
        this.addFiller();
        this.fireComponentsChanged();
        if (selectedCount > 0) {
            for (int dataRowIndex : dataRowIndexes) {
                this.selectionModel.removeSelectedRowIndex(dataRowIndex);
            }
        }
    }

    public void moveDataRowUp(int dataRowIndex) {
        Assert.argument((dataRowIndex >= 1 ? 1 : 0) != 0, (String)"dataRowIndex");
        int rowIndex = dataRowIndex + 1;
        boolean selected = this.selectionModel.isRowSelected(dataRowIndex);
        List<JComponent> componentRow = this.componentRows.remove(rowIndex);
        this.componentRows.add(rowIndex - 1, componentRow);
        for (int i = rowIndex - 1; i < this.componentRows.size(); ++i) {
            List<JComponent> componentRowToUpdate = this.componentRows.get(i);
            this.removeComponentRowIntern(componentRowToUpdate);
            this.addComponentRowIntern(componentRowToUpdate, i);
        }
        this.fireComponentsChanged();
        if (selected) {
            this.selectionModel.removeSelectedRowIndex(dataRowIndex);
            this.selectionModel.addSelectedRowIndex(dataRowIndex - 1);
        }
    }

    public void moveDataRowDown(int dataRowIndex) {
        Assert.argument((dataRowIndex < this.getDataRowCount() - 1 ? 1 : 0) != 0, (String)"dataRowIndex");
        int rowIndex = dataRowIndex + 1;
        boolean selected = this.selectionModel.isRowSelected(dataRowIndex);
        List<JComponent> componentRow = this.componentRows.remove(rowIndex);
        this.componentRows.add(rowIndex + 1, componentRow);
        for (int i = rowIndex; i < this.componentRows.size(); ++i) {
            List<JComponent> componentRowToUpdate = this.componentRows.get(i);
            this.removeComponentRowIntern(componentRowToUpdate);
            this.addComponentRowIntern(componentRowToUpdate, i);
        }
        this.fireComponentsChanged();
        if (selected) {
            this.selectionModel.removeSelectedRowIndex(dataRowIndex);
            this.selectionModel.addSelectedRowIndex(dataRowIndex + 1);
        }
    }

    public boolean isDataRowSelected(int dataRowIndex) {
        return this.selectionModel.isRowSelected(dataRowIndex);
    }

    public int getSelectedDataRowCount() {
        return this.selectionModel.getSelectedRowCount();
    }

    public int getSelectedDataRowIndex() {
        return this.selectionModel.getMinSelectedRowIndex();
    }

    public int[] getSelectedDataRowIndexes() {
        return this.selectionModel.getSelectedRowIndices();
    }

    public void setSelectedDataRowIndexes(int ... dataRowIndexes) {
        this.selectionModel.setSelectedRowIndices(dataRowIndexes);
    }

    @Override
    public void gridSelectionChanged(GridSelectionModel.Event event) {
        int[] selectedRowIndices = this.selectionModel.getSelectedRowIndices();
        System.out.println("selectedRowIndices = " + Arrays.toString(selectedRowIndices));
        this.adjustHeaderRowSelector();
        this.adjustDataRowSelectors();
    }

    protected void adjustHeaderRowSelector(AbstractButton headerRowSelector, int selectedDataRowCount) {
        int dataRowCount = this.getDataRowCount();
        headerRowSelector.setSelected(dataRowCount > 0 && selectedDataRowCount == dataRowCount);
        headerRowSelector.setEnabled(dataRowCount > 0);
    }

    protected Border createHeaderCellBorder() {
        return new HeaderBorder();
    }

    protected AbstractButton createHeaderRowSelector() {
        return new JCheckBox();
    }

    protected AbstractButton createDataRowSelector() {
        return new JCheckBox();
    }

    private void onHeaderRowSelectorAction() {
        AbstractButton button = (AbstractButton)this.componentRows.get(0).get(0);
        this.setAllDataRowsSelected(button.isSelected());
    }

    private void onDataRowSelectorAction() {
        this.adjustSelectionModel();
    }

    private void setAllDataRowsSelected(boolean selected) {
        if (selected) {
            int dataRowCount = this.getDataRowCount();
            int[] dataRowIndices = new int[dataRowCount];
            for (int i = 0; i < dataRowIndices.length; ++i) {
                dataRowIndices[i] = i;
            }
            this.selectionModel.setSelectedRowIndices(dataRowIndices);
        } else {
            this.selectionModel.setSelectedRowIndices(new int[0]);
        }
    }

    private void adjustHeaderRowSelector() {
        JComponent component = this.componentRows.get(0).get(0);
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            this.adjustHeaderRowSelector(button, this.getSelectedDataRowCount());
        }
    }

    private void adjustDataRowSelectors() {
        for (int rowIndex = 1; rowIndex < this.componentRows.size(); ++rowIndex) {
            Component component = this.componentRows.get(rowIndex).get(0);
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)component;
            int dataRowIndex = rowIndex - 1;
            button.setSelected(this.isDataRowSelected(dataRowIndex));
        }
    }

    private void adjustSelectionModel() {
        ArrayList<Integer> dataRowIndexList = new ArrayList<Integer>();
        for (int rowIndex = 1; rowIndex < this.componentRows.size(); ++rowIndex) {
            AbstractButton button;
            Component component = this.componentRows.get(rowIndex).get(0);
            if (!(component instanceof AbstractButton) || !(button = (AbstractButton)component).isSelected()) continue;
            dataRowIndexList.add(rowIndex - 1);
        }
        int[] dataRowIndices = new int[dataRowIndexList.size()];
        for (int i = 0; i < dataRowIndices.length; ++i) {
            dataRowIndices[i] = (Integer)dataRowIndexList.get(i);
        }
        this.selectionModel.setSelectedRowIndices(dataRowIndices);
    }

    private void addComponentRowIntern(List<JComponent> componentRow, int rowIndex) {
        for (int colIndex = 0; colIndex < componentRow.size(); ++colIndex) {
            JComponent component = componentRow.get(colIndex);
            if (component == null) continue;
            this.remove(component);
            if (rowIndex == 0) {
                this.addHeaderBorder(component);
            }
            this.add((Component)component, TableLayout.cell(rowIndex, colIndex));
        }
    }

    private void removeComponentRowIntern(List<JComponent> componentRow) {
        for (JComponent component : componentRow) {
            if (component == null) continue;
            this.remove(component);
        }
    }

    private void fireComponentsChanged() {
        this.invalidate();
        this.revalidate();
        this.validate();
        this.repaint();
    }

    private void checkColumnCount(JComponent[] components) {
        if (components.length != this.getColumnCount() - 1) {
            throw new IllegalArgumentException("components");
        }
    }

    private void addHeaderBorder(JComponent component) {
        Border oldBorder = component.getBorder();
        Border newBorder = this.createHeaderCellBorder();
        if (oldBorder != null) {
            newBorder = BorderFactory.createCompoundBorder(newBorder, oldBorder);
        }
        component.setBorder(newBorder);
    }

    private void addFiller() {
        this.lastFillerRow = this.getRowCount();
        this.getLayout().setCellWeightY(this.lastFillerRow, 0, 1.0);
        this.getLayout().setCellFill(this.lastFillerRow, 0, TableLayout.Fill.VERTICAL);
        this.add((Component)this.filler, TableLayout.cell(this.lastFillerRow, 0));
    }

    private void removeFiller() {
        if (this.lastFillerRow >= 0) {
            this.getLayout().setCellWeightY(this.lastFillerRow, 0, null);
            this.getLayout().setCellFill(this.lastFillerRow, 0, null);
        }
        this.remove(this.filler);
    }

    private int findRowIndex(JComponent component, int rowOffset) {
        for (int rowIndex = rowOffset; rowIndex < this.componentRows.size(); ++rowIndex) {
            List<JComponent> componentRow = this.componentRows.get(rowIndex);
            for (JComponent jComponent : componentRow) {
                if (jComponent == null || jComponent != component) continue;
                return rowIndex;
            }
        }
        return -1;
    }

    public static class DefaultGridSelectionModel
    implements GridSelectionModel {
        private final SortedSet<Integer> rowIndices = new TreeSet<Integer>();
        private final List<GridSelectionModel.Listener> listeners = new ArrayList<GridSelectionModel.Listener>();

        @Override
        public int getSelectedRowCount() {
            return this.rowIndices.size();
        }

        @Override
        public boolean isRowSelected(int rowIndex) {
            return this.rowIndices.contains(rowIndex);
        }

        @Override
        public int getMinSelectedRowIndex() {
            return this.rowIndices.isEmpty() ? -1 : this.rowIndices.first();
        }

        @Override
        public int getMaxSelectedRowIndex() {
            return this.rowIndices.isEmpty() ? -1 : this.rowIndices.last();
        }

        @Override
        public int[] getSelectedRowIndices() {
            Integer[] integers = this.rowIndices.toArray(new Integer[this.rowIndices.size()]);
            int[] indices = new int[integers.length];
            for (int i = 0; i < integers.length; ++i) {
                indices[i] = integers[i];
            }
            return indices;
        }

        @Override
        public void setSelectedRowIndices(int ... rowIndices) {
            TreeSet<Integer> newRowIndices = new TreeSet<Integer>();
            for (int rowIndex : rowIndices) {
                newRowIndices.add(rowIndex);
            }
            if (!newRowIndices.equals(this.rowIndices)) {
                this.rowIndices.clear();
                this.rowIndices.addAll(newRowIndices);
                this.fireChange(new GridSelectionModel.Event(this));
            }
        }

        @Override
        public void addSelectedRowIndex(int rowIndex) {
            if (!this.rowIndices.contains(rowIndex)) {
                this.rowIndices.add(rowIndex);
                this.fireChange(new GridSelectionModel.Event(this));
            }
        }

        @Override
        public void removeSelectedRowIndex(int rowIndex) {
            if (this.rowIndices.contains(rowIndex)) {
                this.rowIndices.remove(rowIndex);
                this.fireChange(new GridSelectionModel.Event(this));
            }
        }

        @Override
        public void addListener(GridSelectionModel.Listener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeListener(GridSelectionModel.Listener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void fireChange(GridSelectionModel.Event event) {
            for (GridSelectionModel.Listener listener : this.listeners) {
                listener.gridSelectionChanged(event);
            }
        }
    }

    private static class HeaderBorder
    implements Border {
        private HeaderBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(c.getForeground().brighter());
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

