/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.support.PlateCarreeGrid;
import org.esa.snap.binning.support.RotatedLatLonGrid;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RotatedLatLonGridTest_GetCenterLatLon_GetBinIndex {
    private RotatedLatLonGrid rotatedLatLonGrid;
    private PlateCarreeGrid plate_Carree_Grid;

    @Before
    public void setUp() throws Exception {
        this.rotatedLatLonGrid = new RotatedLatLonGrid(180, 10.0, 20.0);
        this.plate_Carree_Grid = new PlateCarreeGrid(180);
    }

    @Test
    public void testCorners() throws Exception {
        long indexUL = 0L;
        long indexUR = 359L;
        long indexLL = 64440L;
        long indexLR = 64799L;
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(0L), (Matcher)CoreMatchers.equalTo((Object)new double[]{89.5, -179.5}));
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(359L), (Matcher)CoreMatchers.equalTo((Object)new double[]{89.5, 179.5}));
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(64440L), (Matcher)CoreMatchers.equalTo((Object)new double[]{-89.5, -179.5}));
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(64799L), (Matcher)CoreMatchers.equalTo((Object)new double[]{-89.5, 179.5}));
        double[] cllUL = this.rotatedLatLonGrid.getCenterLatLon(0L);
        double[] cllUR = this.rotatedLatLonGrid.getCenterLatLon(359L);
        double[] cllLL = this.rotatedLatLonGrid.getCenterLatLon(64440L);
        double[] cllLR = this.rotatedLatLonGrid.getCenterLatLon(64799L);
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(cllUL[0], cllUL[1]), (Matcher)CoreMatchers.equalTo((Object)0L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(cllUR[0], cllUR[1]), (Matcher)CoreMatchers.equalTo((Object)359L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(cllLL[0], cllLL[1]), (Matcher)CoreMatchers.equalTo((Object)64440L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(cllLR[0], cllLR[1]), (Matcher)CoreMatchers.equalTo((Object)64799L));
    }

    @Test
    public void testAroundCenterPos() throws Exception {
        long index1 = 32219L;
        long index2 = 32220L;
        long index3 = 32579L;
        long index4 = 32580L;
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(32219L), (Matcher)CoreMatchers.equalTo((Object)new double[]{0.5, -0.5}));
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(32220L), (Matcher)CoreMatchers.equalTo((Object)new double[]{0.5, 0.5}));
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(32579L), (Matcher)CoreMatchers.equalTo((Object)new double[]{-0.5, -0.5}));
        Assert.assertThat((Object)this.plate_Carree_Grid.getCenterLatLon(32580L), (Matcher)CoreMatchers.equalTo((Object)new double[]{-0.5, 0.5}));
        double[] centerLatLon1 = this.rotatedLatLonGrid.getCenterLatLon(32219L);
        double[] centerLatLon2 = this.rotatedLatLonGrid.getCenterLatLon(32220L);
        double[] centerLatLon3 = this.rotatedLatLonGrid.getCenterLatLon(32579L);
        double[] centerLatLon4 = this.rotatedLatLonGrid.getCenterLatLon(32580L);
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(centerLatLon1[0], centerLatLon1[1]), (Matcher)CoreMatchers.equalTo((Object)32219L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(centerLatLon2[0], centerLatLon2[1]), (Matcher)CoreMatchers.equalTo((Object)32220L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(centerLatLon3[0], centerLatLon3[1]), (Matcher)CoreMatchers.equalTo((Object)32579L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(centerLatLon4[0], centerLatLon4[1]), (Matcher)CoreMatchers.equalTo((Object)32580L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(10.5, 19.5), (Matcher)CoreMatchers.equalTo((Object)32219L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(10.5, 20.5), (Matcher)CoreMatchers.equalTo((Object)32220L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(9.5, 19.5), (Matcher)CoreMatchers.equalTo((Object)32579L));
        Assert.assertThat((Object)this.rotatedLatLonGrid.getBinIndex(9.5, 20.5), (Matcher)CoreMatchers.equalTo((Object)32580L));
    }

    @Test
    public void testIndexOutOfBounds() throws Exception {
        int indexLL = 64440;
        int indexLR = 64799;
        int indexOutOfBBounds = 64800;
        try {
            this.plate_Carree_Grid.getCenterLatLon(64800L);
            Assert.fail((String)"ArrayIndexOutOfBoundException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (Exception e) {
            Assert.fail((String)"ArrayIndexOutOfBoundException expected");
        }
        try {
            this.rotatedLatLonGrid.getCenterLatLon(64800L);
            Assert.fail((String)"ArrayIndexOutOfBoundException expected");
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"ArrayIndexOutOfBoundException expected");
        }
    }
}

