/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.support;

import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.support.RegularGaussianGrid;
import org.junit.Assert;
import org.junit.Test;

public class RegularGaussianGridTest {
    private final PlanetaryGrid grid = new RegularGaussianGrid(64);

    @Test
    public void testGetNumRows() {
        Assert.assertEquals((long)64L, (long)this.grid.getNumRows());
    }

    @Test
    public void testGetNumCols() {
        Assert.assertEquals((long)128L, (long)this.grid.getNumCols(0));
        Assert.assertEquals((long)128L, (long)this.grid.getNumCols(32));
        Assert.assertEquals((long)128L, (long)this.grid.getNumCols(63));
    }

    @Test
    public void testGetRowIndex() {
        Assert.assertEquals((long)2L, (long)this.grid.getRowIndex(270L));
    }

    @Test
    public void testGetNumBins() {
        Assert.assertEquals((long)8192L, (long)this.grid.getNumBins());
    }

    @Test
    public void testGetFirstBinIndex() {
        Assert.assertEquals((long)0L, (long)this.grid.getFirstBinIndex(0));
        Assert.assertEquals((long)1280L, (long)this.grid.getFirstBinIndex(10));
        Assert.assertEquals((long)6400L, (long)this.grid.getFirstBinIndex(50));
    }

    @Test
    public void testGetCenterLat() {
        Assert.assertEquals((double)-51.62573, (double)this.grid.getCenterLat(50), (double)0.0);
        Assert.assertEquals((double)-87.86379, (double)this.grid.getCenterLat(63), (double)0.0);
    }

    @Test
    public void testGetCenterLatLon() {
        double[] center = this.grid.getCenterLatLon(300L);
        double centerLat = center[0];
        Assert.assertEquals((double)82.31291, (double)centerLat, (double)0.0);
        double centerLon = center[1];
        Assert.assertEquals((double)123.75, (double)centerLon, (double)0.0);
    }

    @Test
    public void testGetBinIndex() {
        Assert.assertEquals((long)1952L, (long)this.grid.getBinIndex(45.0, 90.0));
    }
}

