/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import org.esa.snap.binning.reader.CacheEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;

public class CacheEntryTest {
    private ArrayByte testArray;
    private CacheEntry cacheEntry;

    @Before
    public void setUp() {
        this.testArray = new ArrayByte(new int[]{1, 2});
        this.cacheEntry = new CacheEntry((Array)this.testArray);
    }

    @Test
    public void testConstruction() {
        Array data = this.cacheEntry.getData();
        Assert.assertSame((Object)this.testArray, (Object)data);
        Assert.assertTrue((0L < this.cacheEntry.getLastAccess() ? 1 : 0) != 0);
    }

    @Test
    public void testGetDataUpdatesAccessTime() throws InterruptedException {
        long initialTime = this.cacheEntry.getLastAccess();
        Thread.sleep(20L);
        this.cacheEntry.getData();
        long lastAccess = this.cacheEntry.getLastAccess();
        Assert.assertTrue((initialTime < lastAccess ? 1 : 0) != 0);
    }
}

