/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import java.io.File;
import org.esa.snap.binning.reader.BinnedFileFilter;
import org.esa.snap.binning.reader.BinnedProductReader;
import org.esa.snap.binning.reader.BinnedProductReaderPlugin;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BinnedProductReaderPluginTest {
    private BinnedProductReaderPlugin plugin;

    @Before
    public void setUp() {
        this.plugin = new BinnedProductReaderPlugin();
    }

    @Test
    public void testGetInputTypes() {
        Class[] inputTypes = this.plugin.getInputTypes();
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(String.class, (Object)inputTypes[0]);
        Assert.assertEquals(File.class, (Object)inputTypes[1]);
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader readerInstance = this.plugin.createReaderInstance();
        Assert.assertTrue((boolean)(readerInstance instanceof BinnedProductReader));
    }

    @Test
    public void testGetProductFileFilter() {
        SnapFileFilter fileFilter = this.plugin.getProductFileFilter();
        Assert.assertTrue((boolean)(fileFilter instanceof BinnedFileFilter));
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.plugin.getFormatNames();
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"Binned_data_product", (Object)formatNames[0]);
    }

    @Test
    public void testGetFileExtensions() {
        String[] fileExtensions = this.plugin.getDefaultFileExtensions();
        Assert.assertEquals((long)1L, (long)fileExtensions.length);
        Assert.assertEquals((Object)".nc", (Object)fileExtensions[0]);
    }

    @Test
    public void testGetDescription() {
        String description = this.plugin.getDescription(null);
        Assert.assertEquals((Object)"Reader for SeaDAS-Level-3-alike NetCDF files containing binned Level-3 data", (Object)description);
    }

    @Test
    public void testGetDecodeQualification() {
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugin.getDecodeQualification(null));
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.plugin.getDecodeQualification((Object)"MER_FR__1PNUPA20070708_164713_000000982059_00384_27993_4986.N1"));
    }
}

