/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.metadata;

import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.SortedMap;
import java.util.logging.Logger;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorOnMaxSet;
import org.esa.snap.binning.operator.BinningConfig;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.binning.operator.metadata.GlobalMetadata;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class GlobalMetadataTest {
    private static final String TEST_DIR = "test_dir";
    private static final String TEST_PROPERTIES = "param_a = aaaaa\nparam_b = bbbb\nparam_c = CCCC";

    @Test
    public void testCreate_fromBinningOp() throws ParseException {
        BinningOp binningOp = this.createBinningOp();
        GlobalMetadata metadata = GlobalMetadata.create((BinningOp)binningOp);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((Object)"org.esa.snap.binning.operator.BinningOp", metaProperties.get("software_qualified_name"));
        Assert.assertEquals((Object)"Binning", metaProperties.get("software_name"));
        Assert.assertEquals((Object)"1.0", metaProperties.get("software_version"));
        Assert.assertEquals((Object)FileUtils.getFilenameWithoutExtension((String)"output.file"), metaProperties.get("product_name"));
        Assert.assertEquals((Object)"2013-05-01", metaProperties.get("aggregation_period_start"));
        Assert.assertEquals((Object)"15.56 day(s)", metaProperties.get("aggregation_period_duration"));
        Assert.assertEquals((Object)"POLYGON ((10 10, 15 10, 15 12, 10 12, 10 10))", metaProperties.get("region"));
        Assert.assertEquals((Object)"8192", metaProperties.get("num_rows"));
        Assert.assertEquals((Object)"2.446286592055973", metaProperties.get("pixel_size_in_km"));
        Assert.assertEquals((Object)"3", metaProperties.get("super_sampling"));
        Assert.assertEquals((Object)"a_mask_expression", metaProperties.get("mask_expression"));
    }

    @Test
    public void testCreate_fromConfig() {
        BinningConfig config = new BinningConfig();
        config.setNumRows(12);
        config.setSuperSampling(Integer.valueOf(13));
        config.setMaskExpr("14");
        config.setVariableConfigs(new VariableConfig[]{new VariableConfig("var_name", "var_expr")});
        config.setAggregatorConfigs(new AggregatorConfig[]{new AggregatorAverage.Config("variable", "target", Double.valueOf(2.076), Boolean.valueOf(false), Boolean.valueOf(true))});
        config.setMinDataHour(Double.valueOf(15.0));
        config.setTimeFilterMethod(BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY);
        config.setMetadataAggregatorName("NAME");
        config.setStartDateTime("here_we_go");
        config.setPeriodDuration(Double.valueOf(15.88));
        GlobalMetadata metadata = GlobalMetadata.create((BinningConfig)config);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((Object)"12", metaProperties.get("num_rows"));
        Assert.assertEquals((Object)"13", metaProperties.get("super_sampling"));
        Assert.assertEquals((Object)"14", metaProperties.get("mask_expression"));
        Assert.assertEquals((Object)"var_name", metaProperties.get("variable_config.0:name"));
        Assert.assertEquals((Object)"var_expr", metaProperties.get("variable_config.0:expr"));
        Assert.assertEquals((Object)"AVG", metaProperties.get("aggregator_config.0:type"));
        Assert.assertEquals((Object)"false", metaProperties.get("aggregator_config.0:outputCounts"));
        Assert.assertEquals((Object)"true", metaProperties.get("aggregator_config.0:outputSums"));
        Assert.assertEquals((Object)"target", metaProperties.get("aggregator_config.0:targetName"));
        Assert.assertEquals((Object)"variable", metaProperties.get("aggregator_config.0:varName"));
        Assert.assertEquals((Object)"2.076", metaProperties.get("aggregator_config.0:weightCoeff"));
        Assert.assertEquals((Object)"15.0", metaProperties.get("min_data_hour"));
        Assert.assertEquals((Object)"SPATIOTEMPORAL_DATA_DAY", metaProperties.get("time_filter_method"));
        Assert.assertEquals((Object)"NAME", metaProperties.get("metadata_aggregator_name"));
        Assert.assertEquals((Object)"here_we_go", metaProperties.get("aggregation_period_start"));
        Assert.assertEquals((Object)"15.88 day(s)", metaProperties.get("aggregation_period_duration"));
    }

    @Test
    public void testCreateFromConfig_noParametersSet() throws ParseException {
        BinningConfig binningConfig = new BinningConfig();
        GlobalMetadata metadata = GlobalMetadata.create((BinningConfig)binningConfig);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertNull(metaProperties.get("product_name"));
        Assert.assertNull(metaProperties.get("aggregation_period_start"));
        Assert.assertNull(metaProperties.get("aggregation_period_duration"));
        Assert.assertNull(metaProperties.get("region"));
        Assert.assertNull(metaProperties.get("num_rows"));
        Assert.assertNull(metaProperties.get("pixel_size_in_km"));
        Assert.assertNull(metaProperties.get("super_sampling"));
        Assert.assertEquals((Object)"", metaProperties.get("mask_expression"));
        Assert.assertNull(metaProperties.get("variable_config.0:name"));
    }

    @Test
    public void testCreate_timeFilerMethod_timeRange() throws ParseException {
        BinningConfig binningConfig = new BinningConfig();
        binningConfig.setTimeFilterMethod(BinningOp.TimeFilterMethod.TIME_RANGE);
        GlobalMetadata metadata = GlobalMetadata.create((BinningConfig)binningConfig);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((Object)"TIME_RANGE", metaProperties.get("time_filter_method"));
        Assert.assertNull(metaProperties.get("min_data_hour"));
    }

    @Test
    public void testCreate_timeFilterMethod_spatioTemporalDay() throws ParseException {
        BinningConfig binningConfig = new BinningConfig();
        binningConfig.setTimeFilterMethod(BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY);
        binningConfig.setMinDataHour(Double.valueOf(0.8876));
        GlobalMetadata metadata = GlobalMetadata.create((BinningConfig)binningConfig);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((Object)"SPATIOTEMPORAL_DATA_DAY", metaProperties.get("time_filter_method"));
        Assert.assertEquals((Object)"0.8876", metaProperties.get("min_data_hour"));
    }

    @Test
    public void testCreate_variableConfigs() {
        VariableConfig[] variableConfigs = new VariableConfig[]{new VariableConfig("first", "one and one"), new VariableConfig("second", "is two")};
        BinningOp binningOp = new BinningOp();
        binningOp.setVariableConfigs(variableConfigs);
        GlobalMetadata metadata = GlobalMetadata.create((BinningOp)binningOp);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((Object)"first", metaProperties.get("variable_config.0:name"));
        Assert.assertEquals((Object)"one and one", metaProperties.get("variable_config.0:expr"));
        Assert.assertEquals((Object)"second", metaProperties.get("variable_config.1:name"));
        Assert.assertEquals((Object)"is two", metaProperties.get("variable_config.1:expr"));
    }

    @Test
    public void testCreate_aggregatorConfigs() {
        AggregatorConfig[] aggregatorConfigs = new AggregatorConfig[]{new AggregatorAverage.Config("variable_1", "the target", Double.valueOf(1.087), Boolean.valueOf(true), Boolean.valueOf(false)), new AggregatorOnMaxSet.Config("variable_2", "another one", new String[]{"set_1", "set_2"})};
        BinningOp binningOp = new BinningOp();
        binningOp.setAggregatorConfigs(aggregatorConfigs);
        GlobalMetadata metadata = GlobalMetadata.create((BinningOp)binningOp);
        Assert.assertNotNull((Object)metadata);
        SortedMap metaProperties = metadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((Object)"AVG", metaProperties.get("aggregator_config.0:type"));
        Assert.assertEquals((Object)"true", metaProperties.get("aggregator_config.0:outputCounts"));
        Assert.assertEquals((Object)"false", metaProperties.get("aggregator_config.0:outputSums"));
        Assert.assertEquals((Object)"the target", metaProperties.get("aggregator_config.0:targetName"));
        Assert.assertEquals((Object)"variable_1", metaProperties.get("aggregator_config.0:varName"));
        Assert.assertEquals((Object)"1.087", metaProperties.get("aggregator_config.0:weightCoeff"));
        Assert.assertEquals((Object)"ON_MAX_SET", metaProperties.get("aggregator_config.1:type"));
        Assert.assertEquals((Object)"another one", metaProperties.get("aggregator_config.1:onMaxVarName"));
        Assert.assertEquals((Object)"set_1,set_2", metaProperties.get("aggregator_config.1:setVarNames"));
        Assert.assertEquals((Object)"variable_2", metaProperties.get("aggregator_config.1:targetName"));
    }

    @Test
    public void testLoad_fileIsNull() throws IOException {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        GlobalMetadata globalMetadata = new GlobalMetadata();
        globalMetadata.load(null, logger);
        SortedMap metaProperties = globalMetadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((long)0L, (long)metaProperties.size());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{logger});
    }

    @Test
    public void testLoad_fileDoesNotExist() throws IOException {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        GlobalMetadata globalMetadata = new GlobalMetadata();
        globalMetadata.load(new File("over_the_rain.bow"), logger);
        SortedMap metaProperties = globalMetadata.asSortedMap();
        Assert.assertNotNull((Object)metaProperties);
        Assert.assertEquals((long)0L, (long)metaProperties.size());
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).warning("Metadata properties file 'over_the_rain.bow' not found");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{logger});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoad() throws IOException {
        Logger logger = (Logger)Mockito.mock(Logger.class);
        GlobalMetadata globalMetadata = new GlobalMetadata();
        try {
            File propertiesFile = this.writePropertiesFile();
            globalMetadata.load(propertiesFile, logger);
            SortedMap metaProperties = globalMetadata.asSortedMap();
            Assert.assertEquals((Object)"aaaaa", metaProperties.get("param_a"));
            Assert.assertEquals((Object)"bbbb", metaProperties.get("param_b"));
            Assert.assertEquals((Object)"CCCC", metaProperties.get("param_c"));
            ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).info(Mockito.contains((String)"Reading metadata properties file"));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{logger});
        }
        finally {
            this.deletePropertiesFile();
        }
    }

    @Test
    public void testAsMetadataElement() throws ParseException {
        BinningOp binningOp = this.createBinningOp();
        GlobalMetadata globalMetadata = GlobalMetadata.create((BinningOp)binningOp);
        MetadataElement processingGraphElement = globalMetadata.asMetadataElement();
        Assert.assertNotNull((Object)processingGraphElement);
        Assert.assertEquals((Object)"Processing_Graph", (Object)processingGraphElement.getName());
        MetadataElement node_0_Element = processingGraphElement.getElement("node.0");
        Assert.assertNotNull((Object)node_0_Element);
        MetadataElement parameterElement = node_0_Element.getElement("parameters");
        Assert.assertEquals((long)11L, (long)parameterElement.getNumAttributes());
        MetadataAttribute software_qualified_name = parameterElement.getAttribute("software_qualified_name");
        Assert.assertNotNull((Object)software_qualified_name);
        Assert.assertEquals((Object)"org.esa.snap.binning.operator.BinningOp", (Object)software_qualified_name.getData().getElemString());
    }

    @Test
    public void testAsMetadataElement_noMetadataContained() {
        GlobalMetadata globalMetadata = new GlobalMetadata();
        MetadataElement metadataElement = globalMetadata.asMetadataElement();
        Assert.assertNotNull((Object)metadataElement);
        Assert.assertEquals((Object)"Processing_Graph", (Object)metadataElement.getName());
        Assert.assertEquals((long)0L, (long)metadataElement.getNumAttributes());
    }

    @Test
    public void testIsTimeFilterMetadataRequired() {
        Assert.assertFalse((boolean)GlobalMetadata.isTimeFilterMetadataRequired(null));
        Assert.assertFalse((boolean)GlobalMetadata.isTimeFilterMetadataRequired((BinningOp.TimeFilterMethod)BinningOp.TimeFilterMethod.NONE));
        Assert.assertTrue((boolean)GlobalMetadata.isTimeFilterMetadataRequired((BinningOp.TimeFilterMethod)BinningOp.TimeFilterMethod.SPATIOTEMPORAL_DATA_DAY));
        Assert.assertTrue((boolean)GlobalMetadata.isTimeFilterMetadataRequired((BinningOp.TimeFilterMethod)BinningOp.TimeFilterMethod.TIME_RANGE));
    }

    @Test
    public void testToPixelSizeString() {
        Assert.assertEquals((Object)"1821.593952320952", (Object)GlobalMetadata.toPixelSizeString((int)12));
        Assert.assertEquals((Object)"2.446286592055973", (Object)GlobalMetadata.toPixelSizeString((int)8192));
    }

    private void deletePropertiesFile() {
        File testDir = new File(TEST_DIR);
        if (testDir.isDirectory() && !FileUtils.deleteTree((File)testDir)) {
            Assert.fail((String)"unable to delete test directory");
        }
    }

    private File writePropertiesFile() throws IOException {
        File testPropertiesFile;
        File testDir = new File(TEST_DIR);
        if (!testDir.mkdirs()) {
            Assert.fail((String)"unable to create test directory");
        }
        if (!(testPropertiesFile = new File(testDir, "test.properties")).createNewFile()) {
            Assert.fail((String)"unable to create test file");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(testPropertiesFile);
        fileOutputStream.write(TEST_PROPERTIES.getBytes());
        fileOutputStream.close();
        return testPropertiesFile;
    }

    private BinningOp createBinningOp() throws ParseException {
        BinningOp binningOp = new BinningOp();
        binningOp.setOutputFile("output.file");
        binningOp.setStartDateTime("2013-05-01");
        binningOp.setPeriodDuration(Double.valueOf(15.56));
        WKTReader wktReader = new WKTReader();
        binningOp.setRegion(wktReader.read("POLYGON((10 10, 15 10, 15 12, 10 12, 10 10))"));
        binningOp.setTimeFilterMethod(BinningOp.TimeFilterMethod.NONE);
        binningOp.setNumRows(8192);
        binningOp.setSuperSampling(Integer.valueOf(3));
        binningOp.setMaskExpr("a_mask_expression");
        return binningOp;
    }
}

