/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import org.esa.snap.binning.operator.BinningProductFilter;
import org.esa.snap.binning.operator.TimeRangeProductFilter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TimeRangeProductFilterTest {
    private Product product;
    private BinningProductFilter timeRangeProductFilter;
    private BinningProductFilter parent;

    @Before
    public void setUp() throws Exception {
        this.parent = (BinningProductFilter)Mockito.mock(BinningProductFilter.class);
        this.product = (Product)Mockito.mock(Product.class);
        Mockito.when((Object)this.parent.accept(this.product)).thenReturn((Object)true);
        this.timeRangeProductFilter = new TimeRangeProductFilter(this.parent, ProductData.UTC.parse((String)"02-MAY-2013 00:00:00"), ProductData.UTC.parse((String)"02-MAY-2013 23:59:59"));
    }

    @Test
    public void testAcceptProduct_ProductsStartAndEndTimesAreBothWithinRange() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 15:10:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 15:40:00"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testRejectProduct_ParentProductFilterReject() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 15:10:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 15:40:00"));
        Mockito.when((Object)this.parent.accept(this.product)).thenReturn((Object)false);
        Mockito.when((Object)this.parent.getReason()).thenReturn((Object)"parent reason");
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Object)"parent reason"));
    }

    @Test
    public void testRejectProduct_ProductsStartAndEndTimesAreBothBeforeRange() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"01-MAY-2013 15:10:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"01-MAY-2013 15:40:00"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Object)"Does not match the time range."));
    }

    @Test
    public void testRejectProduct_ProductsStartAndEndTimesAreBothAfterRange() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"03-MAY-2013 15:10:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"03-MAY-2013 15:40:00"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Object)"Does not match the time range."));
    }

    @Test
    public void testRejectProduct_ProductsStartTimeIsInsideRange() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 23:30:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"03-MAY-2013 00:30:00"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testRejectProduct_ProductsEndTimeIsInsideRange() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"01-MAY-2013 23:30:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 00:30:00"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testRejectProduct_ProductsStartTimeEqualsRangeStartTime() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 00:00:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 01:00:00"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testRejectProduct_ProductsEndTimeEqualsRangeEndTime() throws Exception {
        Mockito.when((Object)this.product.getStartTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 23:00:00"));
        Mockito.when((Object)this.product.getEndTime()).thenReturn((Object)ProductData.UTC.parse((String)"02-MAY-2013 23:59:59"));
        Assert.assertThat((Object)this.timeRangeProductFilter.accept(this.product), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.timeRangeProductFilter.getReason(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

