/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.File;
import java.nio.MappedByteBuffer;
import org.esa.snap.binning.operator.MappedByteBufferTest;
import org.esa.snap.binning.operator.MappedFile;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MappedFileTest {
    int MiB = 0x100000;
    File file;

    @Before
    public void setUp() throws Exception {
        this.file = MappedByteBufferTest.genTestFile();
        this.file.deleteOnExit();
        MappedByteBufferTest.deleteFile("setUp", this.file);
    }

    @After
    public void tearDown() throws Exception {
        MappedByteBufferTest.deleteFile("tearDown", this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="fails on tearDown()")
    @Test
    public void testRemap() throws Exception {
        int chunkSize = 100 * this.MiB;
        MappedFile mappedFile = MappedFile.open((File)this.file, (long)chunkSize);
        try {
            MappedByteBuffer buffer1 = mappedFile.getBuffer();
            buffer1.putDouble(0, 0.111);
            buffer1.putDouble(chunkSize - 8, 1.222);
        }
        finally {
            Assert.assertEquals((long)chunkSize, (long)this.file.length());
        }
        try {
            MappedByteBuffer buffer2 = mappedFile.remap(0L, (long)(2 * chunkSize));
            Assert.assertEquals((double)0.111, (double)buffer2.getDouble(0), (double)1.0E-10);
            Assert.assertEquals((double)1.222, (double)buffer2.getDouble(chunkSize - 8), (double)1.0E-10);
            buffer2.putDouble(2 * chunkSize - 8, 2.333);
        }
        finally {
            Assert.assertEquals((long)(2 * chunkSize), (long)this.file.length());
        }
        try {
            MappedByteBuffer buffer3 = mappedFile.remap(0L, (long)(3 * chunkSize));
            Assert.assertEquals((double)0.111, (double)buffer3.getDouble(0), (double)1.0E-10);
            Assert.assertEquals((double)1.222, (double)buffer3.getDouble(chunkSize - 8), (double)1.0E-10);
            Assert.assertEquals((double)2.333, (double)buffer3.getDouble(2 * chunkSize - 8), (double)1.0E-10);
            buffer3.putDouble(3 * chunkSize - 8, 3.444);
        }
        finally {
            Assert.assertEquals((long)(3 * chunkSize), (long)this.file.length());
        }
        mappedFile.close();
        mappedFile = MappedFile.open((File)this.file, (long)(3 * chunkSize));
        try {
            MappedByteBuffer buffer4 = mappedFile.remap(0L, (long)(3 * chunkSize));
            Assert.assertEquals((double)0.111, (double)buffer4.getDouble(0), (double)1.0E-10);
            Assert.assertEquals((double)1.222, (double)buffer4.getDouble(chunkSize - 8), (double)1.0E-10);
            Assert.assertEquals((double)2.333, (double)buffer4.getDouble(2 * chunkSize - 8), (double)1.0E-10);
            Assert.assertEquals((double)3.444, (double)buffer4.getDouble(3 * chunkSize - 8), (double)1.0E-10);
        }
        finally {
            Assert.assertEquals((long)(3 * chunkSize), (long)this.file.length());
            mappedFile.close();
        }
    }
}

