/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import com.bc.ceres.binding.BindingException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.snap.binning.operator.FormatterConfig;
import org.esa.snap.core.util.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FormatterConfigTest {
    private FormatterConfig config;

    @Before
    public void initOutputterConfig() throws IOException, BindingException {
        this.config = this.loadConfig("FormatterConfigTest.xml");
    }

    @Test
    public void testOutputterConfig() {
        Assert.assertEquals((Object)"RGB", (Object)this.config.getOutputType());
        Assert.assertEquals((Object)"PNG", (Object)this.config.getOutputFormat());
        Assert.assertEquals((Object)"level-3-rgb.png", (Object)this.config.getOutputFile());
    }

    @Test
    public void testXmlGeneration() throws BindingException {
        String xml = this.config.toXml();
        FormatterConfig configCopy = FormatterConfig.fromXml((String)xml);
        Assert.assertEquals((Object)this.config.getOutputFile(), (Object)configCopy.getOutputFile());
        Assert.assertEquals((Object)this.config.getOutputFormat(), (Object)configCopy.getOutputFormat());
        Assert.assertEquals((Object)this.config.getOutputType(), (Object)configCopy.getOutputType());
        Assert.assertArrayEquals((Object[])this.config.getBandConfigurations(), (Object[])configCopy.getBandConfigurations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormatterConfig loadConfig(String configPath) throws IOException, BindingException {
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(configPath));){
            FormatterConfig formatterConfig = FormatterConfig.fromXml((String)FileUtils.readText((Reader)reader));
            return formatterConfig;
        }
    }
}

