/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.operator.FileBackedSpatialBinCollector;
import org.esa.snap.binning.operator.SpatialBinCollection;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class FileBackedSpatialBinCollectorTest {
    private static final int NUM_FEATURES = 2;

    @Test
    public void testReadFromStream() throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(byteStream);
        dos.writeLong(23L);
        dos.writeInt(2);
        SpatialBin bin1 = this.createSpatialBin(23);
        bin1.write((DataOutput)dos);
        SpatialBin bin2 = this.createSpatialBin(23);
        bin2.write((DataOutput)dos);
        dos.writeLong(1048L);
        dos.writeInt(1);
        SpatialBin bin3 = this.createSpatialBin(1048);
        bin3.write((DataOutput)dos);
        dos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteStream.toByteArray());
        TreeMap map = new TreeMap();
        FileBackedSpatialBinCollector.readFromStream((DataInputStream)new DataInputStream(bais), map);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)map.containsKey(23L));
        Assert.assertTrue((boolean)map.containsKey(1048L));
        List spatialBins23 = (List)map.get(23L);
        Assert.assertEquals((long)2L, (long)spatialBins23.size());
        Assert.assertEquals((double)bin2.getFeatureValues()[0], (double)((SpatialBin)spatialBins23.get(1)).getFeatureValues()[0], (double)1.0E-6);
    }

    @Test
    public void testWriteToStream() throws Exception {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(byteStream);
        TreeMap map = new TreeMap();
        ArrayList<SpatialBin> binList = new ArrayList<SpatialBin>();
        binList.add(this.createSpatialBin(42));
        binList.add(this.createSpatialBin(42));
        binList.add(this.createSpatialBin(42));
        binList.add(this.createSpatialBin(42));
        map.put(42L, binList);
        FileBackedSpatialBinCollector.writeToStream(map, (DataOutputStream)dos);
        ByteArrayInputStream bais = new ByteArrayInputStream(byteStream.toByteArray());
        TreeMap newMap = new TreeMap();
        FileBackedSpatialBinCollector.readFromStream((DataInputStream)new DataInputStream(bais), newMap);
        Assert.assertEquals((long)1L, (long)newMap.size());
        List newBinList = (List)newMap.get(42L);
        Assert.assertEquals((long)4L, (long)newBinList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollecting() throws Exception {
        try (FileBackedSpatialBinCollector binCollector = new FileBackedSpatialBinCollector(26000L);){
            BinningContext ctx = (BinningContext)Mockito.mock(BinningContext.class);
            for (int i = 0; i < 26; ++i) {
                ArrayList<SpatialBin> spatialBins = new ArrayList<SpatialBin>();
                int binIndexOffset = i * 1000;
                for (int j = 0; j < 1000; ++j) {
                    spatialBins.add(new SpatialBin((long)(binIndexOffset + j), 3));
                }
                binCollector.consumeSpatialBins(ctx, spatialBins);
            }
            binCollector.consumingCompleted();
            SpatialBinCollection spatialBinCollection = binCollector.getSpatialBinCollection();
            Assert.assertFalse((boolean)spatialBinCollection.isEmpty());
            Assert.assertEquals((long)26000L, (long)spatialBinCollection.size());
            Iterable collectedBins = spatialBinCollection.getBinCollection();
            int counter = 0;
            for (List collectedBin : collectedBins) {
                Assert.assertEquals((long)counter++, (long)((SpatialBin)collectedBin.get(0)).getIndex());
            }
        }
    }

    private SpatialBin createSpatialBin(int binIndex) {
        SpatialBin bin = new SpatialBin((long)binIndex, 2);
        for (int i = 0; i < 2; ++i) {
            bin.getFeatureValues()[i] = (float)Math.random();
        }
        return bin;
    }
}

