/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorPercentile;
import org.esa.snap.binning.aggregators.AggregatorTestUtils;
import org.esa.snap.binning.support.VectorImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatorPercentileTest {
    BinContext ctx;

    @Before
    public void setUp() throws Exception {
        this.ctx = AggregatorTestUtils.createCtx();
    }

    @Test
    public void testMetadata_P90() {
        AggregatorPercentile agg = new AggregatorPercentile((VariableContext)new MyVariableContext("c"), "c", "target", 90);
        Assert.assertEquals((Object)"c_sum", (Object)agg.getSpatialFeatureNames()[0]);
        Assert.assertEquals((Object)"c_p90", (Object)agg.getTemporalFeatureNames()[0]);
        Assert.assertEquals((Object)"target_p90", (Object)agg.getOutputFeatureNames()[0]);
    }

    @Test
    public void testMetadata_P70() {
        AggregatorPercentile agg = new AggregatorPercentile((VariableContext)new MyVariableContext("c"), "c", "c", 70);
        Assert.assertEquals((Object)"PERCENTILE", (Object)agg.getName());
        Assert.assertEquals((long)1L, (long)agg.getSpatialFeatureNames().length);
        Assert.assertEquals((Object)"c_sum", (Object)agg.getSpatialFeatureNames()[0]);
        Assert.assertEquals((long)1L, (long)agg.getTemporalFeatureNames().length);
        Assert.assertEquals((Object)"c_p70", (Object)agg.getTemporalFeatureNames()[0]);
        Assert.assertEquals((long)1L, (long)agg.getOutputFeatureNames().length);
        Assert.assertEquals((Object)"c_p70", (Object)agg.getOutputFeatureNames()[0]);
    }

    @Test
    public void testAggregatorPercentile() {
        AggregatorPercentile agg = new AggregatorPercentile((VariableContext)new MyVariableContext("c"), "c", "c", 70);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        float sumX = 4.5f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / (float)numObs), (float)svec.get(0), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.4f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.5f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.6f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.7f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.8f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.9f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(1.0f), 1, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)1.0E-5f);
        agg.completeTemporal(this.ctx, 10, (WritableVector)tvec);
        Assert.assertEquals((float)0.77f, (float)tvec.get(0), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)0.77f, (float)out.get(0), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorPercentileWithNaN() {
        AggregatorPercentile agg = new AggregatorPercentile((VariableContext)new MyVariableContext("c"), "c", "target", 50);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(Float.NaN), (WritableVector)svec);
        float sumX = 4.0f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        agg.completeSpatial(this.ctx, 3, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / 2.0f), (float)svec.get(0), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.4f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.5f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.6f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.7f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.9f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN), 1, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)1.0E-5f);
        agg.completeTemporal(this.ctx, 10, (WritableVector)tvec);
        Assert.assertEquals((float)0.6f, (float)tvec.get(0), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)0.6f, (float)out.get(0), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorPercentileWithZeroValues() {
        AggregatorPercentile agg = new AggregatorPercentile((VariableContext)new MyVariableContext("c"), "c", "target", 50);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        agg.completeSpatial(this.ctx, 0, (WritableVector)svec);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        agg.completeTemporal(this.ctx, 0, (WritableVector)tvec);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertTrue((boolean)Float.isNaN(out.get(0)));
    }
}

