/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.aggregators;

import org.esa.snap.binning.BinContext;
import org.esa.snap.binning.MyVariableContext;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.aggregators.AggregatorTestUtils;
import org.esa.snap.binning.support.VectorImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatorAverageTest {
    BinContext ctx;

    @Before
    public void setUp() throws Exception {
        this.ctx = AggregatorTestUtils.createCtx();
    }

    @Test
    public void testMetadata_noSums() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 0.0, false, false);
        Assert.assertEquals((Object)"AVG", (Object)agg.getName());
        String[] spatialFeatureNames = agg.getSpatialFeatureNames();
        Assert.assertEquals((long)2L, (long)spatialFeatureNames.length);
        Assert.assertEquals((Object)"c_sum", (Object)spatialFeatureNames[0]);
        Assert.assertEquals((Object)"c_sum_sq", (Object)spatialFeatureNames[1]);
        String[] temporalFeatureNames = agg.getTemporalFeatureNames();
        Assert.assertEquals((long)3L, (long)temporalFeatureNames.length);
        Assert.assertEquals((Object)"c_sum", (Object)temporalFeatureNames[0]);
        Assert.assertEquals((Object)"c_sum_sq", (Object)temporalFeatureNames[1]);
        Assert.assertEquals((Object)"c_weights", (Object)temporalFeatureNames[2]);
        String[] outputFeatureNames = agg.getOutputFeatureNames();
        Assert.assertEquals((long)2L, (long)outputFeatureNames.length);
        Assert.assertEquals((Object)"c_mean", (Object)outputFeatureNames[0]);
        Assert.assertEquals((Object)"c_sigma", (Object)outputFeatureNames[1]);
    }

    @Test
    public void testMetadata_withSums() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 0.0, false, true);
        Assert.assertEquals((Object)"AVG", (Object)agg.getName());
        String[] spatialFeatureNames = agg.getSpatialFeatureNames();
        Assert.assertEquals((long)2L, (long)spatialFeatureNames.length);
        Assert.assertEquals((Object)"c_sum", (Object)spatialFeatureNames[0]);
        Assert.assertEquals((Object)"c_sum_sq", (Object)spatialFeatureNames[1]);
        String[] temporalFeatureNames = agg.getTemporalFeatureNames();
        Assert.assertEquals((long)3L, (long)temporalFeatureNames.length);
        Assert.assertEquals((Object)"c_sum", (Object)temporalFeatureNames[0]);
        Assert.assertEquals((Object)"c_sum_sq", (Object)temporalFeatureNames[1]);
        Assert.assertEquals((Object)"c_weights", (Object)temporalFeatureNames[2]);
        String[] outputFeatureNames = agg.getOutputFeatureNames();
        Assert.assertEquals((long)3L, (long)outputFeatureNames.length);
        Assert.assertEquals((Object)"c_sum", (Object)outputFeatureNames[0]);
        Assert.assertEquals((Object)"c_sum_sq", (Object)outputFeatureNames[1]);
        Assert.assertEquals((Object)"c_weights", (Object)outputFeatureNames[2]);
    }

    @Test
    public void testAggregatorAverageNoWeight() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", 0.0);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        float sumX = 4.5f;
        float sumXX = 8.75f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / (float)numObs), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / (float)numObs), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 0.04f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        Assert.assertEquals((float)0.70000005f, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.15f, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)4.0f, (float)tvec.get(2), (float)1.0E-5f);
        float mean = 0.17500001f;
        float sigma = (float)Math.sqrt(0.0375f - mean * mean);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)mean, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sigma, (float)out.get(1), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageNoWeightWithNaN() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", 0.0);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(Float.NaN), (WritableVector)svec);
        float sumX = 4.0f;
        float sumXX = 8.5f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / 2.0f), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / 2.0f), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN, Float.NaN), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        float sum = 0.5f;
        float sumSqr = 0.11f;
        float weightSum = 3.0f;
        Assert.assertEquals((float)sum, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumSqr, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weightSum, (float)tvec.get(2), (float)1.0E-5f);
        float mean = sum / weightSum;
        float sigma = (float)Math.sqrt(sumSqr / weightSum - mean * mean);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)mean, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sigma, (float)out.get(1), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageWithWeightWithNaNWithOutputCounts() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 1.0, true, false);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(2), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(Float.NaN), (WritableVector)svec);
        float sumX = 4.0f;
        float sumXX = 8.5f;
        float counts = 2.0f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)counts, (float)svec.get(2), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / counts), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / counts), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(3), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f, 3.0f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f, 2.0f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN, Float.NaN, 0.0f), 5, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f, 7.0f), 7, (WritableVector)tvec);
        float sum = 1.8f;
        float sumSqr = 0.36f;
        float weightSum = 12.0f;
        counts = 12.0f;
        Assert.assertEquals((float)sum, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumSqr, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weightSum, (float)tvec.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)counts, (float)tvec.get(2), (float)1.0E-5f);
        float mean = sum / weightSum;
        float sigma = (float)Math.sqrt(sumSqr / weightSum - mean * mean);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)mean, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sigma, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)counts, (float)out.get(2), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageWeighted() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", 1.0);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        float sumX = 4.5f;
        float sumXX = 8.75f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / (float)numObs), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / (float)numObs), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 0.04f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        Assert.assertEquals((float)2.0f, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)0.4f, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)13.0f, (float)tvec.get(2), (float)1.0E-5f);
        float mean = 0.15384616f;
        float sigma = (float)Math.sqrt(0.03076923f - mean * mean);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)mean, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sigma, (float)out.get(1), (float)1.0E-5f);
    }

    @Test
    public void testSuperSampling() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", 0.0);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        float sumX = 13.5f;
        float sumXX = 26.25f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 9;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / (float)numObs), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / (float)numObs), (float)svec.get(1), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageNoWeight_WithSum() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 0.0, false, true);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        float sumX = 4.5f;
        float sumXX = 8.75f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / (float)numObs), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / (float)numObs), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 0.04f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        sumX = 0.70000005f;
        sumXX = 0.15f;
        float weights = 4.0f;
        Assert.assertEquals((float)sumX, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weights, (float)tvec.get(2), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)sumX, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weights, (float)out.get(2), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageNoWeightWithNaNWithSum() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 0.0, false, true);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(Float.NaN), (WritableVector)svec);
        float sumX = 4.0f;
        float sumXX = 8.5f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / 2.0f), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / 2.0f), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN, Float.NaN), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        sumX = 0.5f;
        sumXX = 0.11f;
        float weightSum = 3.0f;
        Assert.assertEquals((float)sumX, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weightSum, (float)tvec.get(2), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)sumX, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weightSum, (float)out.get(2), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageWithWeightWithNaNWithOutputCountsWithSum() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 1.0, true, true);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(2), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(Float.NaN), (WritableVector)svec);
        float sumX = 4.0f;
        float sumXX = 8.5f;
        float counts = 2.0f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)counts, (float)svec.get(2), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / counts), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / counts), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(3), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f, 3.0f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f, 2.0f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(Float.NaN, Float.NaN, 0.0f), 5, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f, 7.0f), 7, (WritableVector)tvec);
        sumX = 1.8f;
        sumXX = 0.36f;
        float weightSum = 12.0f;
        counts = 12.0f;
        Assert.assertEquals((float)sumX, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weightSum, (float)tvec.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)counts, (float)tvec.get(2), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)sumX, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)weightSum, (float)out.get(2), (float)1.0E-5f);
        Assert.assertEquals((float)counts, (float)out.get(3), (float)1.0E-5f);
    }

    @Test
    public void testAggregatorAverageWeightedWithSum() {
        AggregatorAverage agg = new AggregatorAverage((VariableContext)new MyVariableContext("c"), "c", "c", 1.0, false, true);
        VectorImpl svec = AggregatorTestUtils.vec(Float.NaN, Float.NaN);
        VectorImpl tvec = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        VectorImpl out = AggregatorTestUtils.vec(Float.NaN, Float.NaN, Float.NaN);
        agg.initSpatial(this.ctx, (WritableVector)svec);
        Assert.assertEquals((float)0.0f, (float)svec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)svec.get(1), (float)0.0f);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(1.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(2.5f), (WritableVector)svec);
        agg.aggregateSpatial(this.ctx, AggregatorTestUtils.obsNT(0.5f), (WritableVector)svec);
        float sumX = 4.5f;
        float sumXX = 8.75f;
        Assert.assertEquals((float)sumX, (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)svec.get(1), (float)1.0E-5f);
        int numObs = 3;
        agg.completeSpatial(this.ctx, numObs, (WritableVector)svec);
        Assert.assertEquals((float)(sumX / (float)numObs), (float)svec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)(sumXX / (float)numObs), (float)svec.get(1), (float)1.0E-5f);
        agg.initTemporal(this.ctx, (WritableVector)tvec);
        Assert.assertEquals((float)0.0f, (float)tvec.get(0), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(1), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)tvec.get(2), (float)0.0f);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.3f, 0.09f), 3, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 2, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.2f, 0.04f), 1, (WritableVector)tvec);
        agg.aggregateTemporal(this.ctx, (Vector)AggregatorTestUtils.vec(0.1f, 0.01f), 7, (WritableVector)tvec);
        sumX = 2.0f;
        sumXX = 0.4f;
        float sumW = 13.0f;
        Assert.assertEquals((float)sumX, (float)tvec.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)tvec.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)sumW, (float)tvec.get(2), (float)1.0E-5f);
        agg.computeOutput((Vector)tvec, (WritableVector)out);
        Assert.assertEquals((float)sumX, (float)out.get(0), (float)1.0E-5f);
        Assert.assertEquals((float)sumXX, (float)out.get(1), (float)1.0E-5f);
        Assert.assertEquals((float)sumW, (float)out.get(2), (float)1.0E-5f);
    }
}

