/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.NoSuchElementException;
import javax.media.jai.PlanarImage;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.BinManager;
import org.esa.snap.binning.BinningContext;
import org.esa.snap.binning.CompositingType;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.ObservationIterator;
import org.esa.snap.binning.PlanetaryGrid;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.support.BinningContextImpl;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.binning.support.VariableContextImpl;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ObservationIteratorTest {
    @Test
    public void testIteration() throws Exception {
        int width = 18;
        int height = 36;
        PlanarImage[] sourceImages = ObservationIteratorTest.createSourceImages(width, height);
        CrsGeoCoding gc = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, width, height, -180.0, 90.0, 10.0, 10.0);
        Product product = new Product("name", "desc", width, height);
        product.setSceneGeoCoding((GeoCoding)gc);
        BinningContext binningContext = ObservationIteratorTest.createBinningContext();
        ObservationIterator iterator = ObservationIterator.create((PlanarImage[])sourceImages, null, (Product)product, (float[])new float[]{0.5f}, (Rectangle)sourceImages[0].getBounds(), (BinningContext)binningContext);
        Assert.assertTrue((boolean)iterator.hasNext());
        Observation observation = iterator.next();
        Assert.assertNotNull((Object)observation);
        Assert.assertEquals((long)1L, (long)observation.size());
    }

    @Test
    public void testValuesOfIteratedSamples() throws Exception {
        int width = 12;
        int height = 10;
        PlanarImage[] sourceImages = ObservationIteratorTest.createSourceImages(width, height);
        CrsGeoCoding gc = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, width, height, -180.0, 90.0, 10.0, 10.0);
        Product product = new Product("name", "desc", width, height);
        product.setSceneGeoCoding((GeoCoding)gc);
        BinningContext binningContext = ObservationIteratorTest.createBinningContext();
        ObservationIterator iterator = ObservationIterator.create((PlanarImage[])sourceImages, null, (Product)product, (float[])new float[]{0.5f}, (Rectangle)sourceImages[0].getBounds(), (BinningContext)binningContext);
        Assert.assertTrue((boolean)iterator.hasNext());
        Observation observation = iterator.next();
        Assert.assertNotNull((Object)observation);
        Assert.assertEquals((double)1.0, (double)observation.get(0), (double)1.0E-6);
        observation = ObservationIteratorTest.iterate(iterator, 16);
        Assert.assertEquals((double)17.0, (double)observation.get(0), (double)1.0E-6);
        observation = ObservationIteratorTest.iterate(iterator, 45);
        Assert.assertEquals((double)62.0, (double)observation.get(0), (double)1.0E-6);
        observation = ObservationIteratorTest.iterate(iterator, 57);
        Assert.assertEquals((double)119.0, (double)observation.get(0), (double)1.0E-6);
        observation = iterator.next();
        Assert.assertEquals((double)120.0, (double)observation.get(0), (double)1.0E-6);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIterationWithMask() throws Exception {
        int width = 12;
        int height = 10;
        int size = width * height;
        PlanarImage[] sourceImages = ObservationIteratorTest.createSourceImages(width, height);
        WritableRaster maskTile = Raster.createBandedRaster(0, width, height, 1, new Point(0, 0));
        int[] maskData = new int[size];
        for (int i = 0; i < maskData.length; ++i) {
            maskData[i] = i % 2;
        }
        maskTile.setPixels(0, 0, width, height, maskData);
        CrsGeoCoding gc = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, width, height, -180.0, 90.0, 10.0, 10.0);
        Product product = new Product("name", "desc", width, height);
        product.setSceneGeoCoding((GeoCoding)gc);
        ColorModel cm = PlanarImage.getDefaultColorModel((int)maskTile.getDataBuffer().getDataType(), (int)1);
        BufferedImage bufferedImage = new BufferedImage(cm, maskTile, false, null);
        PlanarImage maskImage = PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage);
        BinningContext binningContext = ObservationIteratorTest.createBinningContext();
        ObservationIterator iterator = ObservationIterator.create((PlanarImage[])sourceImages, (PlanarImage)maskImage, (Product)product, (float[])new float[]{0.5f}, (Rectangle)sourceImages[0].getBounds(), (BinningContext)binningContext);
        Assert.assertTrue((boolean)iterator.hasNext());
        Observation observation = iterator.next();
        Assert.assertNotNull((Object)observation);
        Assert.assertEquals((double)2.0, (double)observation.get(0), (double)1.0E-6);
        observation = ObservationIteratorTest.iterate(iterator, 16);
        Assert.assertEquals((double)34.0, (double)observation.get(0), (double)1.0E-6);
        observation = ObservationIteratorTest.iterate(iterator, 43);
        Assert.assertEquals((double)120.0, (double)observation.get(0), (double)1.0E-6);
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testSuperSampling() throws Exception {
        int width = 2;
        int height = 3;
        PlanarImage[] sourceImages = ObservationIteratorTest.createSourceImages(width, height);
        CrsGeoCoding gc = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, width, height, -180.0, 90.0, 10.0, 10.0);
        Product product = new Product("name", "desc", width, height);
        product.setSceneGeoCoding((GeoCoding)gc);
        BinningContext binningContext = ObservationIteratorTest.createBinningContext();
        ObservationIterator iterator = ObservationIterator.create((PlanarImage[])sourceImages, null, (Product)product, (float[])new float[]{0.25f, 0.75f}, (Rectangle)sourceImages[0].getBounds(), (BinningContext)binningContext);
        Observation observation = ObservationIteratorTest.iterate(iterator, 16);
        Assert.assertEquals((double)4.0, (double)observation.get(0), (double)1.0E-6);
        observation = iterator.next();
        Assert.assertEquals((double)5.0, (double)observation.get(0), (double)1.0E-6);
        observation = iterator.next();
        Assert.assertEquals((double)5.0, (double)observation.get(0), (double)1.0E-6);
        observation = iterator.next();
        Assert.assertEquals((double)5.0, (double)observation.get(0), (double)1.0E-6);
        observation = iterator.next();
        Assert.assertEquals((double)5.0, (double)observation.get(0), (double)1.0E-6);
        observation = iterator.next();
        Assert.assertEquals((double)6.0, (double)observation.get(0), (double)1.0E-6);
        ObservationIteratorTest.iterate(iterator, 3);
        try {
            iterator.next();
            Assert.fail((String)"NoSuchElementException expected");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private static BinningContext createBinningContext() {
        VariableContextImpl variableContext = new VariableContextImpl();
        SEAGrid planetaryGrid = new SEAGrid(6);
        BinManager binManager = new BinManager((VariableContext)variableContext, new Aggregator[0]);
        return new BinningContextImpl((PlanetaryGrid)planetaryGrid, binManager, CompositingType.BINNING, 1, null, null);
    }

    private static PlanarImage[] createSourceImages(int width, int height) {
        WritableRaster sourceTile = Raster.createBandedRaster(3, width, height, 1, new Point(0, 0));
        int[] sourceData = new int[width * height];
        for (int i = 0; i < sourceData.length; ++i) {
            sourceData[i] = i + 1;
        }
        sourceTile.setPixels(0, 0, width, height, sourceData);
        ColorModel cm = PlanarImage.getDefaultColorModel((int)sourceTile.getDataBuffer().getDataType(), (int)1);
        BufferedImage bufferedImage = new BufferedImage(cm, sourceTile, false, null);
        return new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)bufferedImage)};
    }

    private static Observation iterate(ObservationIterator iterator, int steps) {
        Observation last = null;
        for (int i = 0; i < steps; ++i) {
            last = iterator.next();
        }
        return last;
    }
}

