/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedFile {
    private final File file;
    private final FileChannel.MapMode mapMode;
    private RandomAccessFile raf;
    private MappedByteBuffer buffer;

    private MappedFile(File file, FileChannel.MapMode mapMode) throws IOException {
        this.file = file;
        this.mapMode = mapMode;
    }

    public static MappedFile open(File file, FileChannel.MapMode mapMode, long position, long size) throws IOException {
        MappedFile mappedFile = new MappedFile(file, mapMode);
        mappedFile.map(position, size);
        return mappedFile;
    }

    public static MappedFile open(File file, long size) throws IOException {
        return MappedFile.open(file, FileChannel.MapMode.READ_WRITE, 0L, size);
    }

    public static MappedFile open(File file) throws IOException {
        return MappedFile.open(file, FileChannel.MapMode.READ_ONLY, 0L, file.length());
    }

    public File getFile() {
        return this.file;
    }

    public MappedByteBuffer getBuffer() {
        return this.buffer;
    }

    public MappedByteBuffer remap(long position, long size) throws IOException {
        this.close();
        this.map(position, size);
        return this.getBuffer();
    }

    public void close() throws IOException {
        this.raf.close();
    }

    private void map(long position, long size) throws IOException {
        this.raf = new RandomAccessFile(this.file, this.mapMode == FileChannel.MapMode.READ_WRITE ? "rw" : "r");
        this.buffer = this.raf.getChannel().map(this.mapMode, position, size);
    }
}

