/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.operator.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.binning.AggregatorConfig;
import org.esa.snap.binning.aggregators.AggregatorAverage;
import org.esa.snap.binning.operator.BinningOp;
import org.esa.snap.binning.operator.VariableConfig;
import org.esa.snap.binning.operator.ui.BinningFormModel;
import org.esa.snap.core.datamodel.Product;
import org.junit.Assert;
import org.junit.Test;

public class BinningFormModelTest {
    @Test
    public void testSetGetProperty() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        PropertySet propertySet = binningFormModel.getBindingContext().getPropertySet();
        propertySet.addProperty(this.createProperty("key", Float[].class));
        propertySet.addProperty(this.createProperty("key2", Integer[].class));
        binningFormModel.setProperty("key", (Object)new Float[]{Float.valueOf(2.0f), Float.valueOf(3.0f)});
        binningFormModel.setProperty("key2", (Object)new Integer[]{10, 20, 30});
        Assert.assertArrayEquals((Object[])new Product[0], (Object[])binningFormModel.getSourceProducts());
        Assert.assertArrayEquals((Object[])new Float[]{Float.valueOf(2.0f), Float.valueOf(3.0f)}, (Object[])((Object[])binningFormModel.getPropertyValue("key")));
        Assert.assertArrayEquals((Object[])new Integer[]{10, 20, 30}, (Object[])((Object[])binningFormModel.getPropertyValue("key2")));
    }

    @Test
    public void testAggregatorConfigsProperty() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        Assert.assertArrayEquals((Object[])new AggregatorConfig[0], (Object[])binningFormModel.getAggregatorConfigs());
        AggregatorAverage.Config aggConf1 = new AggregatorAverage.Config("x", "y", Double.valueOf(0.4), Boolean.valueOf(true), Boolean.valueOf(false));
        AggregatorAverage.Config aggConf2 = new AggregatorAverage.Config("a", "b", Double.valueOf(0.6), Boolean.valueOf(false), null);
        binningFormModel.setProperty("aggregatorConfigs", (Object)new AggregatorConfig[]{aggConf1, aggConf2});
        Assert.assertArrayEquals((Object[])new AggregatorConfig[]{aggConf1, aggConf2}, (Object[])binningFormModel.getAggregatorConfigs());
    }

    @Test
    public void testVariableConfigsProperty() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        Assert.assertArrayEquals((Object[])new VariableConfig[0], (Object[])binningFormModel.getVariableConfigs());
        VariableConfig varConf = new VariableConfig();
        varConf.setName("prefix");
        varConf.setExpr("NOT algal_2");
        binningFormModel.setProperty("variableConfigs", (Object)new VariableConfig[]{varConf});
        Assert.assertArrayEquals((Object[])new VariableConfig[]{varConf}, (Object[])binningFormModel.getVariableConfigs());
    }

    @Test
    public void testListening() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        PropertySet propertySet = binningFormModel.getBindingContext().getPropertySet();
        propertySet.addProperty(this.createProperty("key1", String.class));
        propertySet.addProperty(this.createProperty("key2", String.class));
        MyPropertyChangeListener listener = new MyPropertyChangeListener();
        binningFormModel.addPropertyChangeListener((PropertyChangeListener)listener);
        binningFormModel.setProperty("key1", (Object)"value1");
        binningFormModel.setProperty("key2", (Object)"value2");
        Assert.assertEquals((Object)"value1", (Object)listener.targetMap.get("key1"));
        Assert.assertEquals((Object)"value2", (Object)listener.targetMap.get("key2"));
    }

    @Test
    public void testGetStartDate() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        binningFormModel.setProperty("timeFilterMethod", (Object)BinningOp.TimeFilterMethod.NONE);
        Assert.assertNull((Object)binningFormModel.getStartDateTime());
        binningFormModel.setProperty("timeFilterMethod", (Object)BinningOp.TimeFilterMethod.TIME_RANGE);
        binningFormModel.setProperty("startDateTime", (Object)"2000-01-01");
        Assert.assertNotNull((Object)binningFormModel.getStartDateTime());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String expectedString = dateFormat.format(new GregorianCalendar(2000, 0, 1).getTime());
        Assert.assertEquals((Object)expectedString, (Object)binningFormModel.getStartDateTime());
    }

    @Test
    public void testGetValidExpression() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        Assert.assertTrue((boolean)Boolean.parseBoolean(binningFormModel.getMaskExpr()));
        binningFormModel.setProperty("maskExpr", (Object)"some_expression");
        Assert.assertEquals((Object)"some_expression", (Object)binningFormModel.getMaskExpr());
    }

    @Test
    public void testGetSuperSampling() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        Assert.assertEquals((long)1L, (long)binningFormModel.getSuperSampling());
        binningFormModel.setProperty("superSampling", (Object)10);
        Assert.assertEquals((long)10L, (long)binningFormModel.getSuperSampling());
    }

    @Test
    public void testGetNumRows() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        Assert.assertEquals((long)2160L, (long)binningFormModel.getNumRows());
        binningFormModel.setProperty("numRows", (Object)2000);
        Assert.assertEquals((long)2000L, (long)binningFormModel.getNumRows());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetRegion_Fail() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        binningFormModel.getRegion();
    }

    @Test
    public void testGetRegion_Global() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        binningFormModel.setProperty("global", (Object)true);
        Assert.assertEquals((Object)"POLYGON ((-180 -90, 180 -90, 180 90, -180 90, -180 -90))", (Object)binningFormModel.getRegion().toText());
    }

    @Test
    public void testGetRegion_Compute() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        binningFormModel.setProperty("compute", (Object)true);
        Assert.assertNull((Object)binningFormModel.getRegion());
    }

    @Test
    public void testGetRegion_WithSpecifiedRegion() throws Exception {
        BinningFormModel binningFormModel = new BinningFormModel();
        binningFormModel.setProperty("bounds", (Object)true);
        binningFormModel.setProperty("northBound", (Object)50.0);
        binningFormModel.setProperty("eastBound", (Object)15.0);
        binningFormModel.setProperty("westBound", (Object)10.0);
        binningFormModel.setProperty("southBound", (Object)40.0);
        Assert.assertEquals((Object)"POLYGON ((10 40, 10 50, 15 50, 15 40, 10 40))", (Object)binningFormModel.getRegion().toText());
    }

    private Property createProperty(String propertyName, Class<?> type) {
        return new Property(new PropertyDescriptor(propertyName, type), (PropertyAccessor)new DefaultPropertyAccessor());
    }

    private static class MyPropertyChangeListener
    implements PropertyChangeListener {
        Map<String, Object> targetMap = new HashMap<String, Object>();

        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.targetMap.put(evt.getPropertyName(), evt.getNewValue());
        }
    }
}

