/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class ClassConverter
implements Converter<Class> {
    private final ClassLoader classLoader;
    private static Map<String, Class<?>> primitiveTypes = new HashMap();

    public ClassConverter() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ClassConverter(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Class<? extends Class> getValueType() {
        return Class.class;
    }

    @Override
    public Class parse(String text) throws ConversionException {
        if (text.isEmpty()) {
            return null;
        }
        Class<?> aClass = primitiveTypes.get(text);
        if (aClass != null) {
            return aClass;
        }
        if (text.indexOf(46) == -1) {
            try {
                return Class.forName("java.lang." + text);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        try {
            return this.classLoader.loadClass(text);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException(MessageFormat.format("''{0}'' is not a known type.", text));
        }
    }

    @Override
    public String format(Class value) {
        if (value == null) {
            return "";
        }
        Package aPackage = value.getPackage();
        if (aPackage == null || aPackage.getName().equals("java.lang")) {
            return value.getSimpleName();
        }
        return value.getName();
    }

    static {
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveTypes.put("void", Void.TYPE);
    }
}

