/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.ClassScanner;
import com.bc.ceres.binding.DefaultPropertyDescriptorFactory;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyAccessorFactory;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.accessors.ClassFieldAccessor;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.binding.accessors.MapEntryAccessor;
import com.bc.ceres.core.Assert;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyContainer
implements PropertySet {
    private final Map<String, Property> propertyMap = new HashMap<String, Property>(10);
    private final List<Property> propertyList = new ArrayList<Property>(10);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static PropertyContainer createObjectBacked(Object object) {
        return PropertyContainer.createObjectBacked(object, new DefaultPropertyDescriptorFactory());
    }

    public static PropertyContainer createObjectBacked(Object object, PropertyDescriptorFactory descriptorFactory) {
        return PropertyContainer.createForFields(object.getClass(), descriptorFactory, new ObjectBackedPropertyAccessorFactory(object), false);
    }

    public static PropertyContainer createObjectBacked(Object object, PropertySetDescriptor propertySetDescriptor) {
        Map<String, Field> fields = PropertyContainer.getPropertyFields(object.getClass());
        PropertyContainer propertySet = new PropertyContainer();
        for (String propertyName : propertySetDescriptor.getPropertyNames()) {
            PropertyDescriptor propertyDescriptor = propertySetDescriptor.getPropertyDescriptor(propertyName);
            Field field = fields.get(propertyDescriptor.getName());
            if (field == null) continue;
            propertyDescriptor.initDefaults();
            propertySet.addProperty(new Property(propertyDescriptor, new ClassFieldAccessor(object, field)));
        }
        return propertySet;
    }

    public static PropertyContainer createMapBacked(Map<String, Object> map) {
        PropertyContainer propertyContainer = new PropertyContainer();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, value.getClass());
            propertyDescriptor.initDefaults();
            propertyContainer.addProperty(new Property(propertyDescriptor, new MapEntryAccessor(map, name)));
        }
        return propertyContainer;
    }

    public static PropertyContainer createMapBacked(Map<String, Object> map, PropertySetDescriptor propertySetDescriptor) {
        PropertyContainer propertySet = new PropertyContainer();
        for (String propertyName : propertySetDescriptor.getPropertyNames()) {
            PropertyDescriptor propertyDescriptor = propertySetDescriptor.getPropertyDescriptor(propertyName);
            propertyDescriptor.initDefaults();
            propertySet.addProperty(new Property(propertyDescriptor, new MapEntryAccessor(map, propertyName)));
        }
        return propertySet;
    }

    public static PropertyContainer createMapBacked(Map<String, Object> map, Class<?> templateType) {
        return PropertyContainer.createMapBacked(map, templateType, new DefaultPropertyDescriptorFactory());
    }

    public static PropertyContainer createMapBacked(Map<String, Object> map, Class<?> templateType, PropertyDescriptorFactory descriptorFactory) {
        return PropertyContainer.createForFields(templateType, descriptorFactory, new MapBackedPropertyAccessorFactory(map), false);
    }

    public static PropertyContainer createValueBacked(Class<?> templateType) {
        return PropertyContainer.createValueBacked(templateType, new DefaultPropertyDescriptorFactory());
    }

    public static PropertyContainer createValueBacked(Class<?> templateType, PropertyDescriptorFactory descriptorFactory) {
        return PropertyContainer.createForFields(templateType, descriptorFactory, new ValueBackedPropertyAccessorFactory(), true);
    }

    public static PropertyContainer createForFields(Class<?> type, PropertyDescriptorFactory descriptorFactory, PropertyAccessorFactory accessorFactory, boolean initValues) {
        PropertyContainer container = new PropertyContainer();
        PropertyContainer.collectProperties(type, descriptorFactory, accessorFactory, container);
        if (initValues) {
            container.setDefaultValues();
        }
        return container;
    }

    static Map<String, Field> getPropertyFields(Class<?> type) {
        return ClassScanner.getFields(type, new ClassScanner.FieldFilter(){

            @Override
            public boolean accept(Field field) {
                int modifiers = field.getModifiers();
                return !Modifier.isFinal(modifiers) && !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers);
            }
        });
    }

    @Override
    public Property[] getProperties() {
        return this.propertyList.toArray(new Property[this.propertyList.size()]);
    }

    @Override
    public boolean isPropertyDefined(String name) {
        return this.propertyMap.containsKey(name);
    }

    @Override
    public Property getProperty(String name) {
        Assert.notNull((Object)name, (String)"name");
        return this.propertyMap.get(name);
    }

    @Override
    public void addProperty(Property property) {
        if (this.propertyMap.put(property.getName(), property) != property) {
            String alias = property.getDescriptor().getAlias();
            if (alias != null && !alias.isEmpty()) {
                this.propertyMap.put(alias, property);
            }
            this.propertyList.add(property);
            property.setContainer(this);
        }
    }

    @Override
    public void addProperties(Property ... properties) {
        for (Property property : properties) {
            this.addProperty(property);
        }
    }

    @Override
    public void removeProperty(Property property) {
        if (this.propertyMap.remove(property.getName()) != null) {
            String alias = property.getDescriptor().getAlias();
            if (alias != null && !alias.isEmpty()) {
                this.propertyMap.remove(alias);
            }
            this.propertyList.remove(property);
            property.setContainer(null);
        }
    }

    @Override
    public void removeProperties(Property ... properties) {
        for (Property property : properties) {
            this.removeProperty(property);
        }
    }

    @Override
    public <T> T getValue(String name) {
        Property property = this.getProperty(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    @Override
    public void setValue(String name, Object value) throws IllegalArgumentException {
        try {
            this.getProperty(name).setValue(value);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public PropertyDescriptor getDescriptor(String name) {
        Property property = this.getProperty(name);
        if (property == null) {
            return null;
        }
        return this.getProperty(name).getDescriptor();
    }

    @Override
    public void setDefaultValues() throws IllegalStateException {
        for (Property property : this.getProperties()) {
            PropertyDescriptor descriptor = property.getDescriptor();
            if (descriptor.getDefaultValue() == null) continue;
            try {
                property.setValue(descriptor.getDefaultValue());
            }
            catch (ValidationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(l);
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.getPropertyChangeSupport().addPropertyChangeListener(name, l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.getPropertyChangeSupport().removePropertyChangeListener(name, l);
    }

    PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    private static void collectProperties(Class<?> type, PropertyDescriptorFactory descriptorFactory, PropertyAccessorFactory accessorFactory, PropertySet propertySet) {
        Map<String, Field> fields = PropertyContainer.getPropertyFields(type);
        for (String key : fields.keySet()) {
            Field field = fields.get(key);
            PropertyDescriptor descriptor = descriptorFactory.createValueDescriptor(field);
            if (descriptor == null) continue;
            descriptor.initDefaults();
            PropertyAccessor accessor = accessorFactory.createValueAccessor(field);
            if (accessor == null) continue;
            propertySet.addProperty(new Property(descriptor, accessor));
        }
    }

    private static class ValueBackedPropertyAccessorFactory
    implements PropertyAccessorFactory {
        private ValueBackedPropertyAccessorFactory() {
        }

        @Override
        public PropertyAccessor createValueAccessor(Field field) {
            return new DefaultPropertyAccessor();
        }
    }

    private static class MapBackedPropertyAccessorFactory
    implements PropertyAccessorFactory {
        private final Map<String, Object> map;

        private MapBackedPropertyAccessorFactory(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public PropertyAccessor createValueAccessor(Field field) {
            return new MapEntryAccessor(this.map, field.getName());
        }
    }

    private static class ObjectBackedPropertyAccessorFactory
    implements PropertyAccessorFactory {
        private final Object object;

        private ObjectBackedPropertyAccessorFactory(Object object) {
            this.object = object;
        }

        @Override
        public PropertyAccessor createValueAccessor(Field field) {
            return new ClassFieldAccessor(this.object, field);
        }
    }
}

