/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.arcbin;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.esa.beam.framework.dataio.ProductIOException;

public class Header {
    public static final String FILE_NAME = "hdr.adf";
    private static final String MAGIC = "GRID1.2\u0000";
    private static final CompoundType TYPE = TypeBuilder.COMPOUND((String)"Header", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"HMagic", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.BYTE, (int)8)), TypeBuilder.MEMBER((String)"unknown1", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.BYTE, (int)8)), TypeBuilder.MEMBER((String)"HCellType", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"unknown2", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.BYTE, (int)236)), TypeBuilder.MEMBER((String)"HPixelSizeX", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"HPixelSizeY", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"XRef", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"YRef", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"HTilesPerRow", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"HTilesPerColumn", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"HTileXSize", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"unknown3", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"HTileYSize", (Type)TypeBuilder.INT)});
    final int cellType;
    public final double pixelSizeX;
    public final double pixelSizeY;
    final double xRef;
    final double yRef;
    final int tilesPerRow;
    final int tilesPerColumn;
    final int tileXSize;
    final int tileYSize;

    private Header(int cellType, double pixelSizeX, double pixelSizeY, double xRef, double yRef, int tilesPerRow, int tilesPerColumn, int tileXSize, int tileYSize) {
        this.cellType = cellType;
        this.pixelSizeX = pixelSizeX;
        this.pixelSizeY = pixelSizeY;
        this.xRef = xRef;
        this.yRef = yRef;
        this.tilesPerRow = tilesPerRow;
        this.tilesPerColumn = tilesPerColumn;
        this.tileXSize = tileXSize;
        this.tileYSize = tileYSize;
    }

    public static Header create(File file) throws IOException {
        DataFormat dataFormat = new DataFormat(TYPE, ByteOrder.BIG_ENDIAN);
        DataContext context = dataFormat.createContext(file, "r");
        CompoundData data = context.createData();
        SequenceData magic = data.getSequence("HMagic");
        if (Header.checkMagicString(magic)) {
            Header header = new Header(data.getInt("HCellType"), data.getDouble("HPixelSizeX"), data.getDouble("HPixelSizeX"), data.getDouble("XRef"), data.getDouble("YRef"), data.getInt("HTilesPerRow"), data.getInt("HTilesPerColumn"), data.getInt("HTileXSize"), data.getInt("HTileYSize"));
            context.dispose();
            return header;
        }
        context.dispose();
        throw new ProductIOException("Wrong magic string in 'hdr.adf' file.");
    }

    private static boolean checkMagicString(SequenceData magic) throws IOException {
        byte[] magicBytes = MAGIC.getBytes();
        for (int i = 0; i < MAGIC.length(); ++i) {
            if (magicBytes[i] == magic.getByte(i)) continue;
            return false;
        }
        return true;
    }
}

