/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.arcbin;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.esa.beam.dataio.arcbin.ArcBinGridReaderPlugIn;
import org.esa.beam.dataio.arcbin.ColorPalette;
import org.esa.beam.dataio.arcbin.FloatGridTileProvider;
import org.esa.beam.dataio.arcbin.GeorefBounds;
import org.esa.beam.dataio.arcbin.GridTileOpImage;
import org.esa.beam.dataio.arcbin.GridTileProvider;
import org.esa.beam.dataio.arcbin.Header;
import org.esa.beam.dataio.arcbin.IntegerGridTileProvider;
import org.esa.beam.dataio.arcbin.LegendFile;
import org.esa.beam.dataio.arcbin.MetaDataHandler;
import org.esa.beam.dataio.arcbin.RasterDataFile;
import org.esa.beam.dataio.arcbin.RasterStatistics;
import org.esa.beam.dataio.arcbin.TileIndex;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductIOException;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.CrsGeoCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.util.math.MathUtils;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.UTMRef;

public class ArcBinGridReader
extends AbstractProductReader {
    private RasterDataFile rasterDataFile;
    private static final String BAND_NAME = "classes";
    private static final String PRODUCT_TYPE = "ARC_INFO_BIN_GRID";

    protected ArcBinGridReader(ArcBinGridReaderPlugIn readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        ColorPaletteDef colorPaletteDef;
        GridTileProvider gridTileProvider;
        File file = new File(String.valueOf(this.getInput()));
        File gridDir = file.getParentFile();
        GeorefBounds georefBounds = GeorefBounds.create(ArcBinGridReader.getCaseInsensitiveFile(gridDir, "dblbnd.adf"));
        RasterStatistics rasterStatistics = RasterStatistics.create(ArcBinGridReader.getCaseInsensitiveFile(gridDir, "sta.adf"));
        File headerFile = ArcBinGridReader.getCaseInsensitiveFile(gridDir, "hdr.adf");
        Header header = Header.create(headerFile);
        int width = MathUtils.floorInt((double)((georefBounds.upperRightX - georefBounds.lowerLeftX) / header.pixelSizeX));
        int height = MathUtils.floorInt((double)((georefBounds.upperRightY - georefBounds.lowerLeftY) / header.pixelSizeY));
        int numTiles = header.tilesPerColumn * header.tilesPerRow;
        TileIndex tileIndex = TileIndex.create(ArcBinGridReader.getCaseInsensitiveFile(gridDir, "w001001x.adf"), numTiles);
        this.rasterDataFile = RasterDataFile.create(ArcBinGridReader.getCaseInsensitiveFile(gridDir, "w001001.adf"));
        Product product = new Product(gridDir.getName(), PRODUCT_TYPE, width, height);
        product.setFileLocation(headerFile);
        Dimension gridTileSize = new Dimension(header.tileXSize, header.tileYSize);
        int tileExtend = Math.max(header.tileXSize, header.tileYSize);
        Dimension imageTileSize = new Dimension(tileExtend, tileExtend);
        product.setPreferredTileSize(imageTileSize);
        AffineTransform i2m = ArcBinGridReader.createAffineTransform(georefBounds, header, width, height);
        product.setGeoCoding(ArcBinGridReader.createGeoCoding(width, height, i2m));
        int productDataType = ArcBinGridReader.getDataType(header, rasterStatistics);
        Band band = product.addBand(BAND_NAME, productDataType);
        double nodataValue = ArcBinGridReader.getNodataValue(productDataType);
        band.setNoDataValue(nodataValue);
        band.setNoDataValueUsed(true);
        int databufferType = ImageManager.getDataBufferType((int)productDataType);
        if (ProductData.isIntType((int)productDataType)) {
            gridTileProvider = new IntegerGridTileProvider(this.rasterDataFile, tileIndex, (int)nodataValue, gridTileSize, productDataType);
        } else {
            int tileLength = gridTileSize.width * gridTileSize.height;
            gridTileProvider = new FloatGridTileProvider(this.rasterDataFile, tileIndex, (float)nodataValue, tileLength, productDataType);
        }
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(i2m, width, height);
        AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource((MultiLevelModel)model, (MultiLevelModel)model, width, height, imageTileSize, databufferType, header, gridTileSize, gridTileProvider){
            final /* synthetic */ MultiLevelModel val$model;
            final /* synthetic */ int val$width;
            final /* synthetic */ int val$height;
            final /* synthetic */ Dimension val$imageTileSize;
            final /* synthetic */ int val$databufferType;
            final /* synthetic */ Header val$header;
            final /* synthetic */ Dimension val$gridTileSize;
            final /* synthetic */ GridTileProvider val$gridTileProvider;
            {
                this.val$model = multiLevelModel;
                this.val$width = n;
                this.val$height = n2;
                this.val$imageTileSize = dimension;
                this.val$databufferType = n3;
                this.val$header = header;
                this.val$gridTileSize = dimension2;
                this.val$gridTileProvider = gridTileProvider;
                super(x0);
            }

            protected RenderedImage createImage(int level) {
                if (ArcBinGridReader.this.rasterDataFile != null) {
                    ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)this.val$model, (int)level);
                    return new GridTileOpImage(this.val$width, this.val$height, this.val$imageTileSize, this.val$databufferType, resolutionLevel, this.val$header, this.val$gridTileSize, this.val$gridTileProvider);
                }
                throw new IllegalStateException("rasterDataFile is closed");
            }
        };
        DefaultMultiLevelImage image = new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource);
        band.setSourceImage((MultiLevelImage)image);
        File colorPaletteFile = ColorPalette.findColorPaletteFile(gridDir);
        if (colorPaletteFile != null && (colorPaletteDef = ColorPalette.createColorPalette(colorPaletteFile, rasterStatistics)) != null) {
            band.setImageInfo(new ImageInfo(colorPaletteDef));
            Map<Integer, String> descriptionMap = LegendFile.createDescriptionMap(gridDir);
            IndexCoding indexCoding = ColorPalette.createIndexCoding(colorPaletteDef, descriptionMap);
            product.getIndexCodingGroup().add((ProductNode)indexCoding);
            band.setSampleCoding((SampleCoding)indexCoding);
        }
        MetadataElement metadataRoot = product.getMetadataRoot();
        metadataRoot.addElement(MetaDataHandler.createHeaderElement(header));
        metadataRoot.addElement(MetaDataHandler.createGeorefBoundsElement(georefBounds));
        if (rasterStatistics != null) {
            metadataRoot.addElement(MetaDataHandler.createRasterStatisticsElement(rasterStatistics));
        }
        this.initMetadata(product, headerFile);
        return product;
    }

    protected void initMetadata(Product product, File inputFile) throws IOException {
    }

    private static GeoCoding createGeoCoding(int width, int height, AffineTransform i2m) {
        Rectangle imageBounds = new Rectangle(width, height);
        try {
            DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
            return new CrsGeoCoding((CoordinateReferenceSystem)crs, imageBounds, i2m);
        }
        catch (FactoryException ignored) {
        }
        catch (TransformException ignored) {
            // empty catch block
        }
        return null;
    }

    private static AffineTransform createAffineTransform(GeorefBounds georefBounds, Header header, int width, int height) {
        AffineTransform i2m = new AffineTransform();
        if (georefBounds.lowerLeftX > 180.0 || georefBounds.lowerLeftX < -180.0 || georefBounds.lowerLeftY > 180.0 || georefBounds.lowerLeftY < -180.0) {
            UTMRef utmLL = new UTMRef(georefBounds.lowerLeftX, georefBounds.lowerLeftY, 'N', 18);
            LatLng ll = utmLL.toLatLng();
            UTMRef utmUR = new UTMRef(georefBounds.upperRightX, georefBounds.upperRightY, 'N', 18);
            LatLng ur = utmUR.toLatLng();
            double pixSizeX = Math.abs(ll.getLng() - ur.getLng()) / (double)width;
            double pixSizeY = Math.abs(ll.getLat() - ur.getLat()) / (double)height;
            i2m.translate(ll.getLng(), ll.getLat());
            i2m.scale(pixSizeX, -pixSizeY);
        } else {
            i2m.translate(georefBounds.lowerLeftX, georefBounds.lowerLeftY);
            i2m.scale(header.pixelSizeX, -header.pixelSizeY);
        }
        i2m.translate(0.0, -height);
        return i2m;
    }

    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        throw new IOException("ArcBinGridReader.readBandRasterDataImpl itentionally not implemented");
    }

    public void close() throws IOException {
        super.close();
        if (this.rasterDataFile != null) {
            this.rasterDataFile.close();
            this.rasterDataFile = null;
        }
    }

    private static int getDataType(Header header, RasterStatistics rasterStatistics) throws ProductIOException {
        int cellType = header.cellType;
        if (cellType == 1) {
            if (rasterStatistics != null && rasterStatistics.min >= 0.0 && rasterStatistics.max <= 254.0) {
                return 20;
            }
            if (rasterStatistics != null && rasterStatistics.min >= -32767.0 && rasterStatistics.max <= 32767.0) {
                return 11;
            }
            return 12;
        }
        if (cellType == 2) {
            return 30;
        }
        throw new ProductIOException("Unsupported data type: " + cellType);
    }

    private static double getNodataValue(int dataType) throws ProductIOException {
        if (dataType == 30) {
            return -3.4028234663852886E38;
        }
        if (dataType == 20) {
            return 255.0;
        }
        if (dataType == 11) {
            return -32768.0;
        }
        if (dataType == 12) {
            return -2.147483647E9;
        }
        throw new ProductIOException("Unsupported data type: " + dataType);
    }

    static File getCaseInsensitiveFile(File dir, String lowerCaseName) {
        File lowerCaseFile = new File(dir, lowerCaseName);
        if (lowerCaseFile.exists()) {
            return lowerCaseFile;
        }
        File upperCaseFile = new File(dir, lowerCaseName.toUpperCase());
        if (upperCaseFile.exists()) {
            return upperCaseFile;
        }
        return null;
    }
}

