/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.MsgBase;
import java.util.Arrays;

class MsgDataSpace
extends MsgBase {
    final int msgVersion = 1;
    int spaceFlag = 0;
    int[] varDims;
    int rank;
    long totNumEle;
    int[] dimMaxSizes;
    long[] dimPermuations;

    MsgDataSpace(int rank, long totNumEle, int[] varDims, HdfGroup hdfGroup, HdfFileWriter hdfFile) {
        super(1, hdfGroup, hdfFile);
        this.rank = rank;
        this.totNumEle = totNumEle;
        this.varDims = (int[])(varDims == null ? null : Arrays.copyOf(varDims, varDims.length));
        this.dimMaxSizes = this.varDims;
        if (hdfFile.bugs >= 5) {
            MsgDataSpace.prtf("MsgDataSpace: " + this, new Object[0]);
        }
    }

    @Override
    public String toString() {
        long ilen;
        int i$;
        int len$;
        int[] arr$;
        String res = "rank: " + this.rank;
        res = res + "  totNumEle: " + this.totNumEle;
        res = res + "  dims:";
        if (this.varDims == null) {
            res = res + " null";
        } else {
            res = res + " (";
            arr$ = this.varDims;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                ilen = arr$[i$];
                res = res + " " + ilen;
            }
            res = res + ")";
        }
        if (this.hdfFile.bugs >= 10) {
            res = res + "  dimMaxSizes:";
            if (this.dimMaxSizes == null) {
                res = res + " null";
            } else {
                res = res + " (";
                arr$ = this.dimMaxSizes;
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    ilen = arr$[i$];
                    res = res + " " + ilen;
                }
                res = res + ")";
            }
            res = res + "  " + super.toString();
        }
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        int ii;
        fmtBuf.putBufByte("MsgDataSpace: msgVersion", 2);
        fmtBuf.putBufByte("MsgDataSpace: rank", this.rank);
        fmtBuf.putBufByte("MsgDataSpace: spaceFlag", this.spaceFlag);
        int stype = this.varDims == null ? 2 : (this.varDims.length == 0 ? 0 : 1);
        fmtBuf.putBufByte("MsgDataSpace: stype", stype);
        for (ii = 0; ii < this.rank; ++ii) {
            fmtBuf.putBufLong("MsgDataSpace: varDims", this.varDims[ii]);
        }
        if ((this.spaceFlag & 1) != 0) {
            for (ii = 0; ii < this.rank; ++ii) {
                fmtBuf.putBufLong("MsgDataSpace: dimMaxSizes", this.dimMaxSizes[ii]);
            }
        }
    }
}

