/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.core.util.SystemUtils;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.hdf4.H4iosp;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5iosp;
import ucar.nc2.iosp.netcdf3.N3raf;
import ucar.nc2.util.DiskCache;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.UncompressInputStream;
import ucar.unidata.io.bzip2.CBZip2InputStream;
import ucar.unidata.util.StringUtil2;

public class NetcdfFileOpener {
    private static final Logger LOG = SystemUtils.LOG;
    private static final int MAGIC_BUFFER_LENGTH = 8;
    private static final int COPY_BUFFER_LENGTH = 100000;
    private static final byte[] NC3_MAGIC = new byte[]{67, 68, 70, 1};
    private static final byte[] NC3_MAGIC_LONG = new byte[]{67, 68, 70, 2};
    private static final byte[] H4_MAGIC = new byte[]{14, 3, 19, 1};
    private static final byte[] H5_MAGIC = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};

    public static NetcdfFile open(Object input) throws IOException {
        try {
            byte[] buffer = new byte[8];
            NetcdfFileOpener.readMagicBytes(input, buffer);
            IOServiceProvider spi = NetcdfFileOpener.getIOSpi(buffer);
            if (spi != null) {
                RandomAccessFile raf = NetcdfFileOpener.getRaf(input);
                if (raf != null) {
                    return new DummyNetcdfFile(spi, raf, raf.getLocation());
                }
            } else {
                RandomAccessFile rafForTesting = NetcdfFileOpener.getRafForTesting(input);
                boolean isValidHdf5 = H5header.isValidFile(rafForTesting);
                if (isValidHdf5) {
                    RandomAccessFile raf = NetcdfFileOpener.getRaf(input);
                    if (raf != null) {
                        return new DummyNetcdfFile((IOServiceProvider)new H5iosp(), raf, raf.getLocation());
                    }
                } else if (!(input instanceof ImageInputStream)) {
                    rafForTesting.close();
                }
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            throw new IOException("Error while opening netcdf file", t);
        }
        return null;
    }

    private static File getFile(Object input) {
        if (input instanceof String) {
            String inputString = (String)input;
            String filePrefix = "file:";
            if (inputString.startsWith(filePrefix)) {
                inputString = inputString.substring(filePrefix.length());
            }
            return new File(inputString);
        }
        if (input instanceof File) {
            return (File)input;
        }
        throw new IllegalArgumentException();
    }

    private static void readMagicBytes(Object input, byte[] buffer) throws IOException {
        if (input instanceof String || input instanceof File) {
            NetcdfFileOpener.readMagicBytesFromFile(NetcdfFileOpener.getFile(input), buffer);
        } else if (input instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)input;
            imageInputStream.seek(0L);
            imageInputStream.read(buffer);
        }
    }

    private static RandomAccessFile getRafForTesting(Object input) throws IOException {
        if (input instanceof String || input instanceof File) {
            File file = NetcdfFileOpener.getFile(input);
            MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(NetcdfFileOpener.openInputStream(file));
            return new ImageInputStreamRandomAccessFile(imageInputStream, file.length());
        }
        if (input instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)input;
            return new ImageInputStreamRandomAccessFile(imageInputStream, imageInputStream.length());
        }
        throw new IllegalArgumentException();
    }

    private static InputStream openInputStream(File file) throws IOException {
        String fileName = file.getName().toLowerCase();
        InputStream is = new BufferedInputStream(new FileInputStream(file));
        if (fileName.endsWith(".z")) {
            is = new UncompressInputStream(is);
        } else if (fileName.endsWith(".zip")) {
            ZipInputStream zin = new ZipInputStream(is);
            ZipEntry ze = zin.getNextEntry();
            if (ze != null) {
                is = zin;
            }
        } else if (fileName.endsWith(".bz2")) {
            is = new CBZip2InputStream(is, true);
        } else if (fileName.endsWith(".gzip") || fileName.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    private static void readMagicBytesFromFile(File file, byte[] buffer) throws IOException {
        try (InputStream iss = NetcdfFileOpener.openInputStream(file);){
            iss.read(buffer);
        }
    }

    private static IOServiceProvider getIOSpi(byte[] buffer) {
        AbstractIOServiceProvider spi = null;
        if (NetcdfFileOpener.testMagicBytes(buffer, NC3_MAGIC)) {
            spi = new N3raf();
        } else if (NetcdfFileOpener.testMagicBytes(buffer, NC3_MAGIC_LONG)) {
            spi = new N3raf();
        } else if (NetcdfFileOpener.testMagicBytes(buffer, H4_MAGIC)) {
            spi = new H4iosp();
        } else if (NetcdfFileOpener.testMagicBytes(buffer, H5_MAGIC)) {
            spi = new H5iosp();
        }
        return spi;
    }

    private static boolean testMagicBytes(byte[] buffer, byte[] magic) {
        for (int i = 0; i < magic.length; ++i) {
            if (buffer[i] == magic[i]) continue;
            return false;
        }
        return true;
    }

    private static RandomAccessFile getRaf(Object input) throws IOException {
        if (input instanceof String) {
            String location = (String)input;
            return NetcdfFileOpener.getRafFromFile(location);
        }
        if (input instanceof File) {
            File file = (File)input;
            return NetcdfFileOpener.getRafFromFile(file.getAbsolutePath());
        }
        if (input instanceof ImageInputStream) {
            ImageInputStream imageInputStream = (ImageInputStream)input;
            return new ImageInputStreamRandomAccessFile(imageInputStream, imageInputStream.length());
        }
        return null;
    }

    private static RandomAccessFile getRafFromFile(String location) throws IOException {
        String uriString = location.trim();
        if ((uriString = StringUtil2.replace(uriString, '\\', "/")).startsWith("file:")) {
            uriString = StringUtil2.unescape(uriString.substring(5));
        }
        String uncompressedFileName = null;
        try {
            uncompressedFileName = NetcdfFileOpener.makeUncompressed(uriString);
        }
        catch (Exception e) {
            LOG.warning("Failed to uncompress " + uriString + " err= " + e.getMessage() + "; try as a regular file.");
        }
        RandomAccessFile raf = uncompressedFileName != null ? new RandomAccessFile(uncompressedFileName, "r") : new RandomAccessFile(uriString, "r");
        return raf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String makeUncompressed(String filename) throws Exception {
        File uncompressedFile;
        block68: {
            int pos = filename.lastIndexOf(46);
            if (pos < 0) {
                return null;
            }
            String suffix = filename.substring(pos + 1);
            String uncompressedFilename = filename.substring(0, pos);
            if (!(suffix.equalsIgnoreCase("Z") || suffix.equalsIgnoreCase("zip") || suffix.equalsIgnoreCase("gzip") || suffix.equalsIgnoreCase("gz") || suffix.equalsIgnoreCase("bz2"))) {
                return null;
            }
            uncompressedFile = DiskCache.getFileStandardPolicy(uncompressedFilename);
            if (uncompressedFile.exists() && uncompressedFile.length() > 0L) {
                FileInputStream stream = null;
                FileLock lock = null;
                try {
                    stream = new FileInputStream(uncompressedFile);
                    while (true) {
                        try {
                            lock = stream.getChannel().lock(0L, 1L, true);
                        }
                        catch (OverlappingFileLockException oe) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e1) {
                                break;
                            }
                        }
                    }
                    LOG.fine("found uncompressed " + uncompressedFile + " for " + filename);
                    String oe = uncompressedFile.getPath();
                    return oe;
                }
                finally {
                    if (lock != null) {
                        lock.release();
                    }
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            File file = new File(filename);
            if (!file.exists()) {
                return null;
            }
            FileOutputStream fout = new FileOutputStream(uncompressedFile);
            FileLock lock = null;
            while (true) {
                try {
                    lock = fout.getChannel().lock(0L, 1L, false);
                }
                catch (OverlappingFileLockException oe) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            try {
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(filename), 100000);
                if (suffix.equalsIgnoreCase("Z")) {
                    try (UncompressInputStream in = new UncompressInputStream(inputStream);){
                        NetcdfFileOpener.copy(in, fout, 100000);
                    }
                    LOG.fine("uncompressed " + filename + " to " + uncompressedFile);
                    break block68;
                }
                if (suffix.equalsIgnoreCase("zip")) {
                    ZipInputStream zin = new ZipInputStream(inputStream);
                    ZipEntry ze = zin.getNextEntry();
                    if (ze != null) {
                        NetcdfFileOpener.copy(zin, fout, 100000);
                        LOG.fine("unzipped " + filename + " entry " + ze.getName() + " to " + uncompressedFile);
                    }
                    break block68;
                }
                if (suffix.equalsIgnoreCase("bz2")) {
                    try (CBZip2InputStream in = new CBZip2InputStream(inputStream, true);){
                        NetcdfFileOpener.copy(in, fout, 100000);
                    }
                    LOG.fine("unbzipped " + filename + " to " + uncompressedFile);
                    break block68;
                }
                if (!suffix.equalsIgnoreCase("gzip") && !suffix.equalsIgnoreCase("gz")) break block68;
                try (GZIPInputStream in = new GZIPInputStream(inputStream);){
                    NetcdfFileOpener.copy(in, fout, 100000);
                }
                LOG.fine("ungzipped " + filename + " to " + uncompressedFile);
            }
            catch (Exception e) {
                fout.close();
                fout = null;
                if (uncompressedFile.exists() && !uncompressedFile.delete()) {
                    LOG.warning("failed to delete uncompressed file (IOException)" + uncompressedFile);
                }
                throw e;
            }
            finally {
                if (lock != null) {
                    lock.release();
                }
                if (fout != null) {
                    fout.close();
                }
            }
        }
        return uncompressedFile.getPath();
    }

    private static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private static class ImageInputStreamRandomAccessFile
    extends RandomAccessFile {
        private final ImageInputStream imageInputStream;
        private final long length;

        public ImageInputStreamRandomAccessFile(ImageInputStream imageInputStream, long length) {
            super(16000);
            this.imageInputStream = imageInputStream;
            this.length = length;
        }

        @Override
        public String getLocation() {
            return "ImageInputStream";
        }

        @Override
        public long length() throws IOException {
            return this.length;
        }

        @Override
        protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
            this.imageInputStream.seek(pos);
            return this.imageInputStream.read(b, offset, len);
        }

        @Override
        public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
            int n = (int)nbytes;
            byte[] buff = new byte[n];
            int done = this.read_(offset, buff, 0, n);
            dest.write(ByteBuffer.wrap(buff));
            return done;
        }

        @Override
        public void close() throws IOException {
            this.imageInputStream.close();
        }
    }

    private static class DummyNetcdfFile
    extends NetcdfFile {
        private DummyNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location) throws IOException {
            super(spi, raf, location, null);
        }
    }
}

