/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.worldwind;

import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.ScreenImage;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwindx.examples.analytics.AnalyticSurfaceLegend;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class ColorBarLegend
extends AnalyticSurfaceLegend {
    private double theMinValue;
    private double theMaxValue;

    public void setColorGradient(int width, int height, double minValue, double maxValue, double minHue, double maxHue, Color borderColor, Iterable<? extends AnalyticSurfaceLegend.LabelAttributes> labels, AnalyticSurfaceLegend.LabelAttributes titleLabel, boolean whiteZero) {
        this.screenImage = new ScreenImage();
        this.screenImage.setImageSource(this.createColorGradientLegendImage(width, height, minHue, maxHue, borderColor, whiteZero));
        this.labels = this.createColorGradientLegendLabels(width, height, minValue, maxValue, labels, titleLabel);
        this.theMinValue = minValue;
        this.theMaxValue = maxValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage createColorGradientLegendImage(int width, int height, double minHue, double maxHue, Color borderColor, boolean whiteZero) {
        BufferedImage image = new BufferedImage(width, height, 6);
        Graphics2D g2d = image.createGraphics();
        try {
            for (int y = 0; y < height; ++y) {
                double a = 1.0 - (double)y / (double)(height - 1);
                double hue = WWMath.mix(a, minHue, maxHue);
                double sat = 1.0;
                if (whiteZero) {
                    sat = Math.abs(WWMath.mix(a, -1.0, 1.0));
                }
                g2d.setColor(Color.getHSBColor((float)hue, (float)sat, 1.0f));
                g2d.drawLine(0, y, width - 1, y);
            }
            if (borderColor != null) {
                g2d.setColor(borderColor);
                g2d.drawRect(0, 0, width - 1, height - 1);
            }
        }
        finally {
            g2d.dispose();
        }
        return image;
    }

    public void render(DrawContext dc) {
        double x = dc.getView().getViewport().getWidth() - 75.0;
        double y = 320.0;
        this.setScreenLocation(new Point((int)x, 320));
        super.render(dc);
    }

    public double getMinValue() {
        return this.theMinValue;
    }

    public double getMaxValue() {
        return this.theMaxValue;
    }
}

