/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.CheckBoxListCellRenderer;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener {
    private boolean _useRendererAsConverter = false;

    public ListSearchable(JList jList) {
        super(jList);
        jList.getModel().addListDataListener(this);
        jList.addPropertyChangeListener("model", this);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JList) {
            ((JList)this._component).getModel().removeListDataListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    @Override
    public void setSelectedIndex(int n, boolean bl) {
        if (bl) {
            ((JList)this._component).addSelectionInterval(n, n);
        } else if (((JList)this._component).getSelectedIndex() != n) {
            ((JList)this._component).setSelectedIndex(n);
        }
        ((JList)this._component).ensureIndexIsVisible(n);
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this._component).getSelectedIndex();
    }

    @Override
    protected Object getElementAt(int n) {
        ListModel listModel = ((JList)this._component).getModel();
        return listModel.getElementAt(n);
    }

    @Override
    protected int getElementCount() {
        ListModel listModel = ((JList)this._component).getModel();
        return listModel.getSize();
    }

    @Override
    protected String convertElementToString(Object object) {
        Component component;
        ListCellRenderer<Object> listCellRenderer;
        if (this.isUseRendererAsConverter() && (listCellRenderer = ((JList)this._component).getCellRenderer()) != null && (component = listCellRenderer.getListCellRendererComponent((JList)this._component, object, 0, false, false)) != null) {
            ListCellRenderer listCellRenderer2;
            if (component instanceof JLabel) {
                return ((JLabel)component).getText();
            }
            if (component instanceof CheckBoxListCellRenderer && (listCellRenderer2 = ((CheckBoxListCellRenderer)component).getActualListRenderer()) != null && listCellRenderer2 instanceof JLabel) {
                return ((JLabel)((Object)listCellRenderer2)).getText();
            }
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (listDataEvent.getIndex0() == -1 && listDataEvent.getIndex1() == -1) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            ListModel listModel;
            this.hidePopup();
            ListModel listModel2 = (ListModel)propertyChangeEvent.getOldValue();
            if (listModel2 != null) {
                listModel2.removeListDataListener(this);
            }
            if ((listModel = (ListModel)propertyChangeEvent.getNewValue()) != null) {
                listModel.addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    public boolean isUseRendererAsConverter() {
        return this._useRendererAsConverter;
    }

    public void setUseRendererAsConverter(boolean bl) {
        this._useRendererAsConverter = bl;
    }
}

