/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.math.Histogram;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.watermask.operator.WatermaskUtils;

class RasterImageOutputter {
    private static final int TILE_WIDTH = WatermaskUtils.computeSideLength(50);

    RasterImageOutputter() {
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        if (file.isDirectory()) {
            File[] imgFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".img");
                }
            });
            ExecutorService executorService = Executors.newFixedThreadPool(6);
            for (File imgFile : imgFiles) {
                File outputFile = FileUtils.exchangeExtension((File)imgFile, (String)".png");
                if (outputFile.exists()) continue;
                executorService.submit(new ImageWriterRunnable(imgFile, outputFile));
            }
            executorService.shutdown();
            while (!executorService.isTerminated()) {
                try {
                    executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            InputStream inputStream;
            if (file.getName().toLowerCase().endsWith(".zip")) {
                ZipFile zipFile = new ZipFile(file);
                String shapefile = args[1];
                ZipEntry entry = zipFile.getEntry(shapefile);
                inputStream = zipFile.getInputStream(entry);
            } else {
                inputStream = new FileInputStream(file);
            }
            RasterImageOutputter.writeImage(inputStream, new File(args[args.length - 1]));
        }
    }

    private static boolean writeImage(InputStream inputStream, File outputFile) throws IOException {
        WritableRaster targetRaster = Raster.createPackedRaster(0, TILE_WIDTH, TILE_WIDTH, 1, 1, new Point(0, 0));
        byte[] data = ((DataBufferByte)targetRaster.getDataBuffer()).getData();
        inputStream.read(data);
        BufferedImage image = new BufferedImage(TILE_WIDTH, TILE_WIDTH, 12);
        image.setData(targetRaster);
        boolean valid = RasterImageOutputter.validateImage(image);
        ImageIO.write((RenderedImage)image, "png", outputFile);
        return valid;
    }

    private static boolean validateImage(BufferedImage image) {
        int[] binCounts;
        Histogram histogram = Histogram.computeHistogram((RenderedImage)image, null, (int)3, (Range)new Range(0.0, 3.0));
        for (int binCount : binCounts = histogram.getBinCounts()) {
            if (binCount != 0) continue;
            return false;
        }
        return true;
    }

    private static class ImageWriterRunnable
    implements Runnable {
        private File inputFile;
        private File outputFile;

        private ImageWriterRunnable(File inputFile, File outputFile) {
            this.inputFile = inputFile;
            this.outputFile = outputFile;
        }

        @Override
        public void run() {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.inputFile);
                boolean valid = RasterImageOutputter.writeImage(fileInputStream, this.outputFile);
                if (!valid) {
                    System.out.printf("Not valid: %s%n", this.outputFile);
                } else {
                    System.out.printf("Written: %s%n", this.outputFile);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

