/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;

public class LandMaskRasterCreator {
    private final String targetPath;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            LandMaskRasterCreator.printUsage();
            System.exit(-1);
        }
        LandMaskRasterCreator landMaskRasterCreator = new LandMaskRasterCreator(args[1]);
        String sourcePath = args[0];
        landMaskRasterCreator.createRasterFile(sourcePath);
    }

    private static void printUsage() {
        System.out.println("Usage: ");
        System.out.println("    LandMaskRasterCreator $sourceFile $targetPath");
        System.out.println("    System will exit.");
    }

    public LandMaskRasterCreator(String targetPath) {
        this.targetPath = targetPath;
    }

    void createRasterFile(String sourcePath) throws IOException {
        this.validateSourcePath(sourcePath);
        Product lwProduct = this.readLwProduct(sourcePath);
        Band band = lwProduct.getBand("lw-mask");
        MultiLevelImage sourceImage = band.getSourceImage();
        int numXTiles = sourceImage.getNumXTiles();
        int numYTiles = sourceImage.getNumYTiles();
        int tileWidth = sourceImage.getTileWidth();
        int tileHeight = sourceImage.getTileHeight();
        BufferedImage image = new BufferedImage(tileWidth, tileHeight, 12);
        int count = 0;
        for (int tileX = 0; tileX < numXTiles; ++tileX) {
            for (int tileY = 0; tileY < numYTiles; ++tileY) {
                int minX;
                ++count;
                Raster tile = sourceImage.getTile(tileX, tileY);
                for (int x = minX = tile.getMinX(); x < minX + tile.getWidth(); ++x) {
                    int minY;
                    for (int y = minY = tile.getMinY(); y < minY + tile.getHeight(); ++y) {
                        image.getRaster().setSample(x - minX, y - minY, 0, (byte)tile.getSample(x, y, 0));
                    }
                }
                image.setData(sourceImage.getTile(tileX, tileY));
                System.out.println("Writing image " + count + "/" + numXTiles * numYTiles + ".");
                ImageIO.write((RenderedImage)image, "png", new File(this.targetPath, String.format("%d-%d.png", tileX, tileY)));
            }
        }
    }

    private Product readLwProduct(String sourcePath) {
        Product lwProduct;
        try {
            lwProduct = ProductIO.readProduct((String)sourcePath);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(MessageFormat.format("Unable to read from file ''{0}''.", sourcePath), e);
        }
        return lwProduct;
    }

    void validateSourcePath(String sourcePath) {
        File path = new File(sourcePath);
        if (path.isDirectory()) {
            throw new IllegalArgumentException(MessageFormat.format("Source path ''''{0}'' points to a directory, but must point to a file.", sourcePath));
        }
        if (!path.exists()) {
            throw new IllegalArgumentException(MessageFormat.format("Source path ''{0}'' does not exist.", sourcePath));
        }
    }
}

