/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.watermask.util;

import java.io.File;
import org.esa.snap.watermask.util.ImageDescriptor;

public class ImageDescriptorBuilder {
    private int imageWidth;
    private int imageHeight;
    private int tileWidth;
    private int tileHeight;
    private File auxdataDir;
    private String zipFileName;

    public ImageDescriptorBuilder width(int imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    public ImageDescriptorBuilder height(int imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    public ImageDescriptorBuilder tileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
        return this;
    }

    public ImageDescriptorBuilder tileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
        return this;
    }

    public ImageDescriptorBuilder auxdataDir(File auxdataDir) {
        this.auxdataDir = auxdataDir;
        return this;
    }

    public ImageDescriptorBuilder zipFileName(String fileName) {
        this.zipFileName = fileName;
        return this;
    }

    public ImageDescriptor build() {
        ImageDescriptorImpl imageDescriptor = new ImageDescriptorImpl();
        imageDescriptor.imageWidth = this.imageWidth;
        imageDescriptor.imageHeight = this.imageHeight;
        imageDescriptor.tileWidth = this.tileWidth;
        imageDescriptor.tileHeight = this.tileHeight;
        imageDescriptor.auxdataDir = this.auxdataDir;
        imageDescriptor.zipFileName = this.zipFileName;
        return imageDescriptor;
    }

    private class ImageDescriptorImpl
    implements ImageDescriptor {
        private int imageWidth;
        private int imageHeight;
        private int tileWidth;
        private int tileHeight;
        private File auxdataDir;
        private String zipFileName;

        private ImageDescriptorImpl() {
        }

        @Override
        public int getImageWidth() {
            return this.imageWidth;
        }

        @Override
        public int getImageHeight() {
            return this.imageHeight;
        }

        @Override
        public int getTileWidth() {
            return this.tileWidth;
        }

        @Override
        public int getTileHeight() {
            return this.tileHeight;
        }

        @Override
        public File getAuxdataDir() {
            return this.auxdataDir;
        }

        @Override
        public String getZipFileName() {
            return this.zipFileName;
        }
    }
}

