/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;

public class PromptDialog
extends ModalDialog {
    private boolean ok = false;
    private final Map<String, JComponent> componentMap = new HashMap<String, JComponent>();

    public PromptDialog(String title, String label, String defaultValue, TYPE type) {
        this(title, new Descriptor[]{new Descriptor(label, defaultValue, type)});
    }

    public PromptDialog(String title, Descriptor[] descriptorList) {
        super((Window)SnapApp.getDefault().getMainFrame(), title, 33, null);
        JPanel content = GridBagUtils.createPanel();
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.insets.right = 4;
        gbc.insets.top = 2;
        for (Descriptor descriptor : descriptorList) {
            JComponent prompt = PromptDialog.addComponent(content, gbc, descriptor.label, descriptor.defaultValue, descriptor.type);
            this.componentMap.put(descriptor.label, prompt);
            ++gbc.gridy;
        }
        this.getJDialog().setMinimumSize(new Dimension(400, 100));
        this.setContent(content);
    }

    private static JComponent addComponent(JPanel content, GridBagConstraints gbc, String label, String defaultValue, TYPE type) {
        JTextComponent textComp;
        if (type.equals((Object)TYPE.CHECKBOX)) {
            JCheckBox checkBox = new JCheckBox(label);
            checkBox.setSelected(!defaultValue.isEmpty());
            content.add((Component)checkBox, gbc);
            return checkBox;
        }
        if (type.equals((Object)TYPE.TEXTAREA)) {
            JTextArea textArea = new JTextArea(defaultValue);
            textArea.setColumns(50);
            textArea.setRows(7);
            textComp = textArea;
        } else {
            content.add((Component)new JLabel(label), gbc);
            gbc.weightx = 1.0;
            textComp = new JTextField(defaultValue);
        }
        textComp.setEditable(true);
        content.add((Component)textComp, gbc);
        return textComp;
    }

    public String getValue(String label) throws Exception {
        JComponent component = this.componentMap.get(label);
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            return textComponent.getText();
        }
        throw new Exception(label + " is not a JTextComponent");
    }

    public boolean isSelected(String label) throws Exception {
        JComponent component = this.componentMap.get(label);
        if (component instanceof JCheckBox) {
            JCheckBox checkBox = (JCheckBox)component;
            return checkBox.isSelected();
        }
        throw new Exception(label + " is not a JCheckBox");
    }

    protected void onOK() {
        this.ok = true;
        this.hide();
    }

    public boolean IsOK() {
        return this.ok;
    }

    public static class Descriptor {
        public final String label;
        public final String defaultValue;
        public final TYPE type;

        public Descriptor(String label, String defaultValue, TYPE type) {
            this.label = label;
            this.defaultValue = defaultValue;
            this.type = type;
        }
    }

    public static enum TYPE {
        TEXTFIELD,
        TEXTAREA,
        CHECKBOX;

    }
}

