/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.NestWorldMapPane;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.AppContext;

public class SubsetUI
extends BaseOperatorUI {
    private final JList bandList = new JList();
    private final JTextField regionX = new JTextField("");
    private final JTextField regionY = new JTextField("");
    private final JTextField width = new JTextField("");
    private final JTextField height = new JTextField("");
    private final JTextField subSamplingX = new JTextField("");
    private final JTextField subSamplingY = new JTextField("");
    private final JCheckBox copyMetadata = new JCheckBox("Copy Metadata", true);
    private final JRadioButton pixelCoordRadio = new JRadioButton("Pixel Coordinates");
    private final JRadioButton geoCoordRadio = new JRadioButton("Geographic Coordinates");
    private final JPanel pixelPanel = new JPanel(new GridBagLayout());
    private final JPanel geoPanel = new JPanel(new BorderLayout());
    private final WorldMapUI worldMapUI = new WorldMapUI();
    private final JTextField geoText = new JTextField("");
    private final JButton geoUpdateButton = new JButton("Update");
    private Geometry geoRegion = null;

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.geoText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubsetUI.this.updateGeoRegion();
            }
        });
        this.geoUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SubsetUI.this.updateGeoRegion();
            }
        });
        return new JScrollPane(panel);
    }

    @Override
    public void initParameters() {
        Integer subSamplingYVal;
        Integer subSamplingXVal;
        OperatorUIUtils.initParamList(this.bandList, this.getBandNames(), (Object[])this.paramMap.get("sourceBands"));
        Rectangle region = (Rectangle)this.paramMap.get("region");
        if (region != null) {
            this.regionX.setText(String.valueOf(region.x));
            this.regionY.setText(String.valueOf(region.y));
            this.width.setText(String.valueOf(region.width));
            this.height.setText(String.valueOf(region.height));
        }
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            if (region == null || region.width == 0) {
                this.width.setText(String.valueOf(this.sourceProducts[0].getSceneRasterWidth()));
            }
            if (region == null || region.height == 0) {
                this.height.setText(String.valueOf(this.sourceProducts[0].getSceneRasterHeight()));
            }
            this.worldMapUI.getModel().setAutoZoomEnabled(true);
            this.worldMapUI.getModel().setProducts(this.sourceProducts);
            this.worldMapUI.getModel().setSelectedProduct(this.sourceProducts[0]);
            this.worldMapUI.getWorlMapPane().zoomToProduct(this.sourceProducts[0]);
        }
        if ((subSamplingXVal = (Integer)this.paramMap.get("subSamplingX")) != null) {
            this.subSamplingX.setText(subSamplingXVal.toString());
        }
        if ((subSamplingYVal = (Integer)this.paramMap.get("subSamplingY")) != null) {
            this.subSamplingY.setText(subSamplingYVal.toString());
        }
        this.geoRegion = (Geometry)this.paramMap.get("geoRegion");
        if (this.geoRegion != null) {
            Coordinate[] coord = this.geoRegion.getCoordinates();
            this.worldMapUI.setSelectionStart((float)coord[0].y, (float)coord[0].x);
            this.worldMapUI.setSelectionEnd((float)coord[2].y, (float)coord[2].x);
            this.getGeoRegion();
            this.geoCoordRadio.setSelected(true);
            this.pixelPanel.setVisible(false);
            this.geoPanel.setVisible(true);
        }
    }

    @Override
    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    @Override
    public void updateParameters() {
        String subSamplingYStr;
        String heightStr;
        String widthStr;
        String regionYStr;
        OperatorUIUtils.updateParamList(this.bandList, this.paramMap, "bandNames");
        int x = 0;
        int y = 0;
        int w = 0;
        int h = 0;
        String regionXStr = this.regionX.getText();
        if (regionXStr != null && !regionXStr.isEmpty()) {
            x = Integer.parseInt(regionXStr);
        }
        if ((regionYStr = this.regionY.getText()) != null && !regionYStr.isEmpty()) {
            y = Integer.parseInt(regionYStr);
        }
        if ((widthStr = this.width.getText()) != null && !widthStr.isEmpty()) {
            w = Integer.parseInt(widthStr);
        }
        if ((heightStr = this.height.getText()) != null && !heightStr.isEmpty()) {
            h = Integer.parseInt(heightStr);
        }
        this.paramMap.put("region", new Rectangle(x, y, w, h));
        String subSamplingXStr = this.subSamplingX.getText();
        if (subSamplingXStr != null && !subSamplingXStr.isEmpty()) {
            this.paramMap.put("subSamplingX", Integer.parseInt(subSamplingXStr));
        }
        if ((subSamplingYStr = this.subSamplingY.getText()) != null && !subSamplingYStr.isEmpty()) {
            this.paramMap.put("subSamplingY", Integer.parseInt(subSamplingYStr));
        }
        this.getGeoRegion();
        if (this.geoCoordRadio.isSelected() && this.geoRegion != null) {
            this.paramMap.put("geoRegion", this.geoRegion);
        }
        this.paramMap.put("copyMetadata", this.copyMetadata.isSelected());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)new JLabel("Source Bands:"), gbc);
        gbc.fill = 1;
        gbc.gridx = 1;
        contentPane.add((Component)new JScrollPane(this.bandList), gbc);
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.copyMetadata, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.pixelCoordRadio, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.geoCoordRadio, gbc);
        this.pixelCoordRadio.setSelected(true);
        this.pixelCoordRadio.setActionCommand("pixelCoordRadio");
        this.geoCoordRadio.setActionCommand("geoCoordRadio");
        ButtonGroup group = new ButtonGroup();
        group.add(this.pixelCoordRadio);
        group.add(this.geoCoordRadio);
        RadioListener myListener = new RadioListener();
        this.pixelCoordRadio.addActionListener(myListener);
        this.geoCoordRadio.addActionListener(myListener);
        GridBagConstraints pixgbc = DialogUtils.createGridBagConstraints();
        pixgbc.gridwidth = 1;
        pixgbc.fill = 1;
        SubsetUI.addComponent(this.pixelPanel, pixgbc, "X:", this.regionX, 0);
        SubsetUI.addComponent(this.pixelPanel, pixgbc, "Y:", this.regionY, 2);
        ++pixgbc.gridy;
        SubsetUI.addComponent(this.pixelPanel, pixgbc, "Width:", this.width, 0);
        SubsetUI.addComponent(this.pixelPanel, pixgbc, "height:", this.height, 2);
        ++pixgbc.gridy;
        SubsetUI.addComponent(this.pixelPanel, pixgbc, "Sub-sampling X:", this.subSamplingX, 0);
        SubsetUI.addComponent(this.pixelPanel, pixgbc, "Sub-sampling Y:", this.subSamplingY, 2);
        this.pixelPanel.add((Component)new JPanel(), pixgbc);
        NestWorldMapPane worldPane = this.worldMapUI.getWorlMapPane();
        worldPane.setPreferredSize(new Dimension(500, 130));
        JPanel geoTextPanel = new JPanel(new BorderLayout());
        this.geoText.setColumns(45);
        geoTextPanel.add((Component)this.geoText, "Center");
        geoTextPanel.add((Component)this.geoUpdateButton, "East");
        this.geoPanel.add((Component)worldPane, "Center");
        this.geoPanel.add((Component)geoTextPanel, "South");
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        ++gbc.gridy;
        contentPane.add((Component)this.pixelPanel, gbc);
        this.geoPanel.setVisible(false);
        contentPane.add((Component)this.geoPanel, gbc);
        DialogUtils.fillPanel(contentPane, gbc);
        return contentPane;
    }

    public static JLabel addComponent(JPanel contentPane, GridBagConstraints gbc, String text, JComponent component, int pos) {
        gbc.gridx = pos;
        gbc.weightx = 0.5;
        JLabel label = new JLabel(text);
        contentPane.add((Component)label, gbc);
        gbc.gridx = pos + 1;
        gbc.weightx = 2.0;
        contentPane.add((Component)component, gbc);
        gbc.gridx = pos;
        gbc.weightx = 1.0;
        return label;
    }

    private void getGeoRegion() {
        GeoPos[] selectionBox;
        this.geoRegion = null;
        this.geoText.setText("");
        if (this.geoCoordRadio.isSelected() && (selectionBox = this.worldMapUI.getSelectionBox()) != null) {
            Coordinate[] coords = new Coordinate[selectionBox.length + 1];
            for (int i = 0; i < selectionBox.length; ++i) {
                coords[i] = new Coordinate(selectionBox[i].getLon(), selectionBox[i].getLat());
            }
            coords[selectionBox.length] = new Coordinate(selectionBox[0].getLon(), selectionBox[0].getLat());
            GeometryFactory geometryFactory = new GeometryFactory();
            LinearRing linearRing = geometryFactory.createLinearRing(coords);
            this.geoRegion = geometryFactory.createPolygon(linearRing, null);
            this.geoText.setText(this.geoRegion.toText());
        }
    }

    private void updateGeoRegion() {
        try {
            this.geoRegion = new WKTReader().read(this.geoText.getText());
            Coordinate[] coord = this.geoRegion.getCoordinates();
            this.worldMapUI.setSelectionStart((float)coord[0].y, (float)coord[0].x);
            this.worldMapUI.setSelectionEnd((float)coord[2].y, (float)coord[2].x);
            this.worldMapUI.getWorlMapPane().revalidate();
            this.worldMapUI.getWorlMapPane().getLayerCanvas().updateUI();
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("UpdateGeoRegion error reading wkt", (Throwable)e);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().contains("pixelCoordRadio")) {
                SubsetUI.this.pixelPanel.setVisible(true);
                SubsetUI.this.geoPanel.setVisible(false);
                SubsetUI.this.geoRegion = null;
                SubsetUI.this.paramMap.put("geoRegion", SubsetUI.this.geoRegion);
            } else {
                SubsetUI.this.pixelPanel.setVisible(false);
                SubsetUI.this.geoPanel.setVisible(true);
            }
        }
    }
}

