/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import com.bc.ceres.core.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.graphbuilder.gpf.ui.DefaultOperatorUIDescriptor;
import org.esa.snap.graphbuilder.gpf.ui.DefaultUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

public class OperatorUIRegistry {
    private static OperatorUIRegistry instance = null;
    private final Map<String, OperatorUIDescriptor> operatorUIDescriptors = new HashMap<String, OperatorUIDescriptor>();

    public OperatorUIRegistry() {
        this.registerOperatorUIs();
    }

    public static OperatorUIRegistry getInstance() {
        if (instance == null) {
            instance = new OperatorUIRegistry();
        }
        return instance;
    }

    public OperatorUIDescriptor[] getOperatorUIDescriptors() {
        return this.operatorUIDescriptors.values().toArray(new OperatorUIDescriptor[this.operatorUIDescriptors.values().size()]);
    }

    public OperatorUIDescriptor getOperatorUIDescriptor(String operatorName) {
        return this.operatorUIDescriptors.get(operatorName);
    }

    private void registerOperatorUIs() {
        FileObject fileObj = FileUtil.getConfigFile((String)"OperatorUIs");
        if (fileObj == null) {
            SystemUtils.LOG.warning("No operatorUIs found.");
            return;
        }
        FileObject[] files = fileObj.getChildren();
        List orderedFiles = FileUtil.getOrder(Arrays.asList(files), (boolean)true);
        for (FileObject file : orderedFiles) {
            OperatorUIDescriptor operatorUIDescriptor = null;
            try {
                operatorUIDescriptor = OperatorUIRegistry.createOperatorUIDescriptor(file);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(String.format("Failed to create operatorUI from layer.xml path '%s'", file.getPath()));
            }
            if (operatorUIDescriptor == null) continue;
            OperatorUIDescriptor existingDescriptor = this.operatorUIDescriptors.get(operatorUIDescriptor.getOperatorName());
            if (existingDescriptor != null) {
                SystemUtils.LOG.info(String.format("OperatorUI [%s] has been redeclared for [%s]!\n", operatorUIDescriptor.getId(), operatorUIDescriptor.getOperatorName()));
            }
            this.operatorUIDescriptors.put(operatorUIDescriptor.getOperatorName(), operatorUIDescriptor);
            SystemUtils.LOG.fine(String.format("New operatorUI added from layer.xml path '%s': %s", file.getPath(), operatorUIDescriptor.getOperatorName()));
        }
    }

    public static OperatorUIDescriptor createOperatorUIDescriptor(FileObject fileObject) {
        String id = fileObject.getName();
        String operatorName = (String)fileObject.getAttribute("operatorName");
        Assert.argument((operatorName != null && !operatorName.isEmpty() ? 1 : 0) != 0, (String)"Missing attribute 'operatorName'");
        Class<OperatorUI> operatorUIClass = OperatorUIRegistry.getClassAttribute(fileObject, "operatorUIClass", OperatorUI.class, false);
        Boolean disableFromGraphBuilder = false;
        try {
            String disableFromGraphBuilderStr = (String)fileObject.getAttribute("disableFromGraphBuilder");
            if (disableFromGraphBuilderStr != null) {
                disableFromGraphBuilder = Boolean.parseBoolean(disableFromGraphBuilderStr);
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("OperatorUIRegistry: Unable to parse disableFromGraphBuilder " + e.toString());
        }
        return new DefaultOperatorUIDescriptor(id, operatorName, operatorUIClass, disableFromGraphBuilder);
    }

    public static OperatorUI CreateOperatorUI(String operatorName) {
        OperatorUIRegistry reg = OperatorUIRegistry.getInstance();
        if (reg != null) {
            OperatorUIDescriptor desc = reg.getOperatorUIDescriptor(operatorName);
            if (desc != null) {
                return desc.createOperatorUI();
            }
            desc = OperatorUIRegistry.getInstance().getOperatorUIDescriptor("DefaultUI");
            if (desc != null) {
                return desc.createOperatorUI();
            }
        }
        return new DefaultUI();
    }

    public static boolean showInGraphBuilder(String operatorName) {
        OperatorUIDescriptor desc;
        OperatorUIRegistry reg = OperatorUIRegistry.getInstance();
        if (reg != null && (desc = reg.getOperatorUIDescriptor(operatorName)) != null) {
            if (desc.disableFromGraphBuilder().booleanValue()) {
                SystemUtils.LOG.warning(operatorName + " disabled from GraphBuilder");
            }
            return desc.disableFromGraphBuilder() == false;
        }
        return true;
    }

    public static <T> Class<T> getClassAttribute(FileObject fileObject, String attributeName, Class<T> expectedType, boolean required) {
        String className = (String)fileObject.getAttribute(attributeName);
        if (className == null || className.isEmpty()) {
            if (required) {
                throw new IllegalArgumentException(String.format("Missing attribute '%s' of type %s", attributeName, expectedType.getName()));
            }
            return null;
        }
        Collection modules = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo module : modules) {
            if (!module.isEnabled()) continue;
            try {
                Class<?> implClass = module.getClassLoader().loadClass(className);
                if (expectedType.isAssignableFrom(implClass)) {
                    return implClass;
                }
                throw new IllegalArgumentException(String.format("Value %s of attribute '%s' must be a %s", implClass.getName(), attributeName, expectedType.getName()));
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }
}

