/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.javaml.core.AbstractInstance;
import net.sf.javaml.core.Instance;

public class DenseInstance
extends AbstractInstance
implements Instance {
    private static final long serialVersionUID = 3284511291715269081L;
    private double[] attributes;

    public DenseInstance(double[] att) {
        this(att, null);
    }

    public DenseInstance(double[] att, Object classValue) {
        super(classValue);
        this.attributes = (double[])att.clone();
    }

    private DenseInstance() {
    }

    public DenseInstance(int size) {
        this(new double[size]);
    }

    @Override
    public double value(int pos) {
        return this.attributes[pos];
    }

    @Override
    public void clear() {
        this.attributes = new double[this.attributes.length];
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Integer) {
            int i = (Integer)key;
            return i >= 0 && i < this.attributes.length;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Number) {
            double val = ((Number)value).doubleValue();
            for (int i = 0; i < this.attributes.length; ++i) {
                if (!(Math.abs(val - this.attributes[i]) < 1.0E-8)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Map.Entry<Integer, Double>> entrySet() {
        HashMap<Integer, Double> map = new HashMap<Integer, Double>();
        for (int i = 0; i < this.attributes.length; ++i) {
            map.put(i, this.attributes[i]);
        }
        return map.entrySet();
    }

    @Override
    public Double get(Object key) {
        return this.attributes[(Integer)key];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public SortedSet<Integer> keySet() {
        TreeSet<Integer> keys = new TreeSet<Integer>();
        for (int i = 0; i < this.attributes.length; ++i) {
            keys.add(i);
        }
        return keys;
    }

    @Override
    public Double put(Integer key, Double value) {
        double val = this.attributes[key];
        this.attributes[key.intValue()] = value;
        return val;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Double> m) {
        for (Integer n : m.keySet()) {
            this.attributes[n.intValue()] = m.get(n);
        }
    }

    @Override
    public Double remove(Object key) {
        throw new UnsupportedOperationException("Cannot unset values from a dense instance.");
    }

    @Override
    @Deprecated
    public int size() {
        return this.attributes.length;
    }

    @Override
    public Collection<Double> values() {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (double v : this.attributes) {
            vals.add(v);
        }
        return vals;
    }

    @Override
    public int noAttributes() {
        return this.attributes.length;
    }

    public String toString() {
        return "{" + Arrays.toString(this.attributes) + ";" + this.classValue() + "}";
    }

    @Override
    public void removeAttribute(int i) {
        double[] tmp = (double[])this.attributes.clone();
        this.attributes = new double[tmp.length - 1];
        System.arraycopy(tmp, 0, this.attributes, 0, i);
        System.arraycopy(tmp, i + 1, this.attributes, i, tmp.length - i - 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.attributes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DenseInstance other = (DenseInstance)obj;
        return Arrays.equals(this.attributes, other.attributes);
    }

    @Override
    public Instance copy() {
        DenseInstance out = new DenseInstance();
        out.attributes = (double[])this.attributes.clone();
        out.setClassValue(this.classValue());
        return out;
    }

    @Override
    public void removeAttributes(Set<Integer> indices) {
        double[] tmp = (double[])this.attributes.clone();
        this.attributes = new double[tmp.length - indices.size()];
        int index = 0;
        for (int i = 0; i < tmp.length; ++i) {
            if (indices.contains(i)) continue;
            this.attributes[index++] = tmp[i];
        }
    }
}

