/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.bayes;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.sf.javaml.classification.AbstractClassifier;
import net.sf.javaml.classification.bayes.BayesResult;
import net.sf.javaml.classification.bayes.ClassCounter_compact;
import net.sf.javaml.classification.bayes.Functions;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;

public class AbstractBayesianClassifier_compact
extends AbstractClassifier {
    private static final long serialVersionUID = -4142042654172176726L;
    Functions fnc = new Functions();
    protected int numClasses;
    protected int numFeatures;
    protected int numInstances;
    protected boolean laplace;
    protected boolean log;
    protected boolean sparse;
    protected BayesResult trainResult;
    protected Dataset trainingData;
    protected Object[] classes;
    protected HashMap<String, Integer> Classname2IndexCCountermap;
    protected int initialCap;

    public AbstractBayesianClassifier_compact(boolean lap, boolean log, boolean sparse) {
        this.laplace = lap;
        this.log = log;
        this.sparse = sparse;
        this.Classname2IndexCCountermap = new HashMap();
    }

    @Override
    public void buildClassifier(Dataset data) {
        this.trainingData = data;
        this.trainResult = new BayesResult();
        this.numInstances = this.trainingData.size();
        this.numClasses = this.trainingData.classes().size();
        this.classes = new Object[this.numClasses];
        Iterator it = this.trainingData.classes().iterator();
        int cnt = 0;
        while (it.hasNext()) {
            String classname = it.next().toString();
            this.Classname2IndexCCountermap.put(classname, cnt);
            this.classes[cnt] = classname;
            ++cnt;
        }
        this.trainResult.setClassFreqs(this.calculateClassFreqs(this.trainingData));
        this.trainResult.setClassProbs(this.calculateClassProbs());
        this.trainResult.setFeatureTable_compact(this.conditionalFreq_compact(this.trainingData));
        if (this.sparse) {
            this.trainResult.setFeatureTable_compact(this.updateFT_compact());
        }
        this.initialCap = (int)Math.ceil((double)this.numFeatures / 0.75) + 10;
    }

    private Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> updateFT_compact() {
        Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> featureName_HT = this.trainResult.getFeatureTable_compact();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        for (Integer key : featureName_HT.keySet()) {
            if (featureName_HT.get(key).containsKey(12345.6789)) continue;
            featureName_HT.get(key).put(12345.6789, new ClassCounter_compact(this.classes.length));
            for (int k = 0; k < this.numClasses; ++k) {
                featureName_HT.get(key).get(12345.6789).setCountClass(freq[k] - this.sumOccurencesAllFVsForClass_compact(key, k), k);
            }
        }
        return featureName_HT;
    }

    private double sumOccurencesAllFVsForClass_compact(int FN, int c) {
        Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> featureName_HT = this.trainResult.getFeatureTable_compact();
        double Sum_score = 0.0;
        for (Double key2 : featureName_HT.get(FN).keySet()) {
            Sum_score += featureName_HT.get(FN).get(key2).getCountClass(c);
        }
        return Sum_score;
    }

    private double[] calculateClassFreqs(Dataset Instances2Train) {
        double[] classFrequencies = new double[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            classFrequencies[i] = 0.0;
        }
        for (Instance inst : Instances2Train) {
            int n = this.Classname2IndexCCountermap.get(inst.classValue());
            classFrequencies[n] = classFrequencies[n] + 1.0;
        }
        return classFrequencies;
    }

    private double[] calculateClassProbs() {
        double[] probs = (double[])this.trainResult.getClassFreqs().clone();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        for (int k = 0; k < this.numClasses; ++k) {
            probs[k] = (freq[k] + 1.0) / (double)(this.numInstances + this.numClasses);
        }
        return probs;
    }

    private Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> conditionalFreq_compact(Dataset Instances2Train) {
        Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> featureName_HT = new Hashtable<Integer, Hashtable<Double, ClassCounter_compact>>(this.numFeatures);
        for (Instance inst : Instances2Train) {
            for (Object e : inst.keySet()) {
                int featureName = (Integer)e;
                Double featureValue = inst.value((Integer)e);
                if (!featureName_HT.containsKey(featureName)) {
                    Hashtable<Double, ClassCounter_compact> featureValue_CC = new Hashtable<Double, ClassCounter_compact>();
                    featureValue_CC.put(featureValue, new ClassCounter_compact(this.numClasses));
                    featureName_HT.put(featureName, featureValue_CC);
                } else if (!featureName_HT.get(featureName).containsKey(featureValue)) {
                    featureName_HT.get(featureName).put(featureValue, new ClassCounter_compact(this.classes.length));
                }
                featureName_HT.get(featureName).get(featureValue).setCountClass(featureName_HT.get(featureName).get(featureValue).getCountClass(this.Classname2IndexCCountermap.get(inst.classValue())) + 1.0, this.Classname2IndexCCountermap.get(inst.classValue()));
            }
        }
        this.numFeatures = featureName_HT.size();
        return featureName_HT;
    }

    protected double getInstValue(int topology_element, Instance inst) {
        if (!inst.containsKey(topology_element)) {
            return 12345.6789;
        }
        return (Double)inst.get(topology_element);
    }

    public HashMap<Object, Double> calcFictionalChances(HashMap<Object, Double> distribution) {
        double smallestBuildingBlock = 100 / distribution.keySet().size();
        LinkedHashMap outS = this.fnc.sortHashMapByValues(distribution, true);
        int index = 1;
        for (Object key : outS.keySet()) {
            distribution.put(key, (double)index * smallestBuildingBlock);
            ++index;
        }
        return distribution;
    }

    protected void coverAbsentFeatures_And_fill_helpMap_compact(Instance inst) {
        Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> featureName_HT = this.trainResult.getFeatureTable_compact();
        for (Object e : inst.keySet()) {
            int featureName = (Integer)e;
            Double featureValue = inst.value((Integer)e);
            if (!featureName_HT.containsKey(featureName) || featureName_HT.get(featureName).containsKey(featureValue)) continue;
            featureName_HT.get(featureName).put(featureValue, new ClassCounter_compact(this.classes.length));
        }
        this.trainResult.setFeatureTable_compact(featureName_HT);
    }

    public Object[] getClassesMap() {
        return this.classes;
    }

    public HashMap<String, Integer> getClassesRevMap() {
        return this.Classname2IndexCCountermap;
    }

    public double[] getClassFreqs() {
        return (double[])this.trainResult.getClassFreqs().clone();
    }

    public boolean getSparse() {
        return this.sparse;
    }

    public Hashtable<Integer, Hashtable<Double, ClassCounter_compact>> getFeatureTable_compact() {
        return this.trainResult.getFeatureTable_compact();
    }
}

